/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.file;

import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.file.FilePageStore;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FilePageRandomAccess
implements IPageRandomAccess {
    private final FilePageStore mStore;
    private final FileChannel mChannel;
    private boolean mClosed = false;

    public FilePageRandomAccess(FilePageStore store) throws IOException {
        this.mStore = store;
        this.mChannel = new RandomAccessFile(store.getPageFile(), "rw").getChannel();
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public boolean read(long pageIndex, ByteBuffer buf) throws IOException {
        int len;
        int pageSize = this.mStore.getPageSize();
        long pos = pageIndex * (long)pageSize;
        if (pageIndex < 0L) {
            throw new IndexOutOfBoundsException("pageIndex < 0");
        }
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        this.mChannel.position(pos);
        for (int bytesRead = 0; bytesRead < pageSize; bytesRead += len) {
            len = this.mChannel.read(buf);
            if (len >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void write(long pageIndex, ByteBuffer buf) throws IOException {
        int len;
        int pageSize = this.mStore.getPageSize();
        if (pageIndex < 0L) {
            throw new IndexOutOfBoundsException("pageIndex < 0");
        }
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        this.mChannel.position(pageIndex * (long)this.mStore.getPageSize());
        for (int bytesWritten = 0; bytesWritten < pageSize; bytesWritten += len) {
            len = this.mChannel.write(buf);
        }
    }

    @Override
    public void append(ByteBuffer buf) throws IOException {
        int len;
        int pageSize = this.mStore.getPageSize();
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        this.mChannel.position(this.mChannel.size());
        for (int bytesWritten = 0; bytesWritten < pageSize; bytesWritten += len) {
            len = this.mChannel.write(buf);
        }
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void flush() throws IOException {
        this.mChannel.force(true);
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            this.mChannel.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

