/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.file;

import com.ibm.neo.dataimport.cdf.paging.IPageReader;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.file.FilePageStore;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FilePageReader
implements IPageReader {
    private final FilePageStore mStore;
    private final FileChannel mChannel;
    private boolean mClosed = false;

    public FilePageReader(FilePageStore store) throws IOException {
        this.mStore = store;
        this.mChannel = new FileInputStream(store.getPageFile()).getChannel();
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public boolean read(long pageIndex, ByteBuffer buf) throws IOException {
        int len;
        int pageSize = this.mStore.getPageSize();
        long pos = pageIndex * (long)pageSize;
        if (pageIndex < 0L) {
            throw new IndexOutOfBoundsException("pageIndex < 0");
        }
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        this.mChannel.position(pos);
        for (int bytesRead = 0; bytesRead < pageSize; bytesRead += len) {
            len = this.mChannel.read(buf);
            if (len >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            this.mChannel.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

