/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.file;

import com.ibm.neo.dataimport.cdf.paging.IPageAppender;
import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.IPageReader;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.file.FilePageAppender;
import com.ibm.neo.dataimport.cdf.paging.file.FilePageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.file.FilePageReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NullArgumentException;

public class FilePageStore
implements IPageStore {
    private final File mPageFile;
    private final int mPageSize;

    public FilePageStore(File pageFile, int pageSize) throws IOException {
        if (null == pageFile) {
            throw new NullArgumentException("pageFile");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize < 1");
        }
        this.mPageFile = pageFile;
        this.mPageSize = pageSize;
        if (!this.mPageFile.exists()) {
            File parentDir = this.mPageFile.getParentFile();
            if (null != parentDir && !parentDir.exists()) {
                FileUtils.forceMkdir((File)parentDir);
            }
            if (!this.mPageFile.createNewFile()) {
                throw new IOException("Failed to create file: " + this.mPageFile.getAbsolutePath());
            }
        }
    }

    public File getPageFile() {
        return this.mPageFile;
    }

    @Override
    public int getPageSize() {
        return this.mPageSize;
    }

    @Override
    public long getPageCount() {
        return this.mPageFile.length() / (long)this.mPageSize;
    }

    @Override
    public boolean isRandomAccessSupported() {
        return true;
    }

    @Override
    public boolean isAppendPreservationSupported() {
        return true;
    }

    @Override
    public IPageAppender openAppender(boolean preserve) throws IOException {
        return new FilePageAppender(this, preserve);
    }

    @Override
    public IPageReader openReader() throws IOException {
        return new FilePageReader(this);
    }

    @Override
    public IPageRandomAccess openRandomAccess() throws IOException {
        return new FilePageRandomAccess(this);
    }

    @Override
    public void clear() throws IOException {
        if (this.mPageFile.exists()) {
            try (FileChannel channel = new FileOutputStream(this.mPageFile).getChannel();){
                channel.truncate(0L);
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        if (this.mPageFile.exists() && !this.mPageFile.delete()) {
            this.mPageFile.deleteOnExit();
        }
    }
}

