/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.mem;

import com.ibm.neo.dataimport.cdf.paging.IPageAppender;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.mem.MemPageStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MemPageAppender
implements IPageAppender {
    private final MemPageStore mStore;
    private boolean mClosed = false;

    public MemPageAppender(MemPageStore store, boolean preserve) {
        this.mStore = store;
        if (!preserve) {
            store.getPageList().clear();
        }
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public void append(ByteBuffer buf) throws IOException {
        int pageSize = this.mStore.getPageSize();
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        ByteBuffer pageBuf = ByteBuffer.allocate(pageSize);
        pageBuf.order(ByteOrder.BIG_ENDIAN);
        pageBuf.put(buf);
        this.mStore.getPageList().add(pageBuf);
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
    }
}

