/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.mem;

import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.mem.MemPageStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class MemPageRandomAccess
implements IPageRandomAccess {
    private final MemPageStore mStore;
    private boolean mClosed = false;

    public MemPageRandomAccess(MemPageStore store) {
        this.mStore = store;
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public boolean read(long pageIndex, ByteBuffer buf) throws IOException {
        int pageSize = this.mStore.getPageSize();
        if (pageIndex < 0L) {
            throw new IllegalArgumentException("pageIndex < 0");
        }
        if (pageIndex > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("pageIndex > Integer.MAX_VALUE");
        }
        if (pageIndex >= this.mStore.getPageCount()) {
            return false;
        }
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        ByteBuffer pageBuf = this.mStore.getPageList().get((int)pageIndex);
        if (null == pageBuf) {
            return false;
        }
        pageBuf.clear();
        buf.put(pageBuf);
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
    }

    @Override
    public void append(ByteBuffer buf) throws IOException {
        int pageSize = this.mStore.getPageSize();
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        ByteBuffer pageBuf = ByteBuffer.allocate(pageSize);
        pageBuf.order(ByteOrder.BIG_ENDIAN);
        pageBuf.put(buf);
        this.mStore.getPageList().add(pageBuf);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(long pageIndex, ByteBuffer buf) throws IOException {
        int pageSize = this.mStore.getPageSize();
        if (pageIndex < 0L) {
            throw new IllegalArgumentException("pageIndex < 0");
        }
        if (pageIndex > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("pageIndex > Integer.MAX_VALUE");
        }
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        ArrayList<ByteBuffer> pageList = this.mStore.getPageList();
        ByteBuffer pageBuf = null;
        if (pageIndex >= (long)pageList.size()) {
            int i = pageList.size() - 1;
            while ((long)i < pageIndex) {
                pageList.add(null);
                ++i;
            }
            pageBuf = ByteBuffer.allocate(pageSize);
            pageBuf.order(ByteOrder.BIG_ENDIAN);
            pageList.set((int)pageIndex, pageBuf);
        } else {
            pageBuf = pageList.get((int)pageIndex);
            if (null == pageBuf) {
                pageBuf = ByteBuffer.allocate(pageSize);
                pageBuf.order(ByteOrder.BIG_ENDIAN);
                pageList.set((int)pageIndex, pageBuf);
            }
        }
        pageBuf.clear();
        pageBuf.put(buf);
    }
}

