/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.mem;

import com.ibm.neo.dataimport.cdf.paging.IPageReader;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.mem.MemPageStore;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MemPageReader
implements IPageReader {
    private final MemPageStore mStore;
    private boolean mClosed = false;

    public MemPageReader(MemPageStore store) {
        this.mStore = store;
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public boolean read(long pageIndex, ByteBuffer buf) throws IOException {
        if (pageIndex < 0L) {
            throw new IllegalArgumentException("pageIndex < 0");
        }
        if (pageIndex > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("pageIndex > Integer.MAX_VALUE");
        }
        if (pageIndex >= (long)this.mStore.getPageList().size()) {
            return false;
        }
        ByteBuffer pageBuf = this.mStore.getPageList().get((int)pageIndex);
        if (null == pageBuf) {
            return false;
        }
        pageBuf.clear();
        buf.put(pageBuf);
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
    }
}

