/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.mem;

import com.ibm.neo.dataimport.cdf.paging.IPageAppender;
import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.IPageReader;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.mem.MemPageAppender;
import com.ibm.neo.dataimport.cdf.paging.mem.MemPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.mem.MemPageReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class MemPageStore
implements IPageStore {
    private final int mPageSize;
    private final ArrayList<ByteBuffer> mPageList = new ArrayList();

    public MemPageStore(int pageSize) {
        this.mPageSize = pageSize;
    }

    ArrayList<ByteBuffer> getPageList() {
        return this.mPageList;
    }

    @Override
    public int getPageSize() {
        return this.mPageSize;
    }

    @Override
    public long getPageCount() {
        return this.mPageList.size();
    }

    @Override
    public boolean isRandomAccessSupported() {
        return true;
    }

    @Override
    public boolean isAppendPreservationSupported() {
        return true;
    }

    @Override
    public IPageAppender openAppender(boolean preserve) throws IOException {
        return new MemPageAppender(this, preserve);
    }

    @Override
    public IPageReader openReader() throws IOException {
        return new MemPageReader(this);
    }

    @Override
    public IPageRandomAccess openRandomAccess() throws IOException {
        return new MemPageRandomAccess(this);
    }

    @Override
    public void clear() throws IOException {
        this.mPageList.clear();
    }

    @Override
    public void destroy() throws IOException {
        this.mPageList.clear();
    }
}

