/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.archive;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.scrape.AbstractDocumentScraper;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeOptions;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeResult;
import com.ibm.neo.dataimport.cdf.scrape.archive.ZipScraperFactory;
import com.ibm.neo.dataimport.cdf.scrape.dsv.DSVScraper;
import com.ibm.neo.dataimport.cdf.scrape.dsv.DSVScraperFactory;
import com.ibm.neo.dataimport.cdf.scrape.excel.AbstractExcelScraper;
import com.ibm.neo.dataimport.cdf.scrape.excel.ExcelScraperFactory;
import com.ibm.neo.dataimport.cdf.scrape.excel.XLSScraper;
import com.ibm.neo.dataimport.cdf.scrape.excel.XLSXScraper;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipScraper
extends AbstractDocumentScraper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipScraper.class);

    protected ZipScraper(CDFService cdfService) {
        super(cdfService);
    }

    @Override
    public DocumentType getDocumentType() {
        return ZipScraperFactory.ZIP_DOC_TYPE;
    }

    @Override
    public ScrapeResult scrape(String fileName, String mimeType, InputStream input, ScrapeOptions options) throws WAImportException {
        Objects.requireNonNull(fileName);
        Objects.requireNonNull(input);
        ScrapeResult result = null;
        File file = null;
        try {
            file = File.createTempFile(fileName, null, this.mCDFService.getSheetCacheDir());
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            result = this.scrape(fileName, mimeType, file, options);
        }
        catch (IOException ex) {
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.IO_ERROR).withConditionCode(EImportMessageCode.INTERNAL_ERROR).withCause((Throwable)ex).build();
        }
        finally {
            if (file != null && !file.delete()) {
                LOGGER.error("Failed to delete temp file. Will try again on JVM exit.", ZipScraper.class);
                file.deleteOnExit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrapeResult scrape(String fileName, String mimeType, File file, ScrapeOptions options) throws WAImportException {
        Objects.requireNonNull(fileName);
        Objects.requireNonNull(file);
        boolean success = false;
        SortedMap<String, ICDFSheet> orderedSheets = null;
        try {
            orderedSheets = this.getSheets(file, options);
            if (orderedSheets.size() < 1) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.ZIP_NO_SUPPORTED_SHEETS).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
            ScrapeResult result = this.makeResult(fileName, mimeType, orderedSheets);
            success = true;
            ScrapeResult scrapeResult = result;
            return scrapeResult;
        }
        finally {
            if (!success && orderedSheets != null) {
                this.discardSheets(orderedSheets.values());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SortedMap<String, ICDFSheet> getSheets(File file, ScrapeOptions options) throws WAImportException {
        TreeMap<String, ICDFSheet> orderedSheets = new TreeMap<String, ICDFSheet>();
        try (ZipFile zip = new ZipFile(file);){
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || entryName.contains("__MACOSX")) continue;
                this.getSheetsFromEntry(options, orderedSheets, zip, entry, entryName);
            }
            TreeMap<String, ICDFSheet> treeMap = orderedSheets;
            return treeMap;
        }
        catch (IOException ex) {
            LOGGER.error("IO Error", (Throwable)ex);
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.IO_ERROR).withConditionCode(EImportMessageCode.INTERNAL_ERROR).withCause((Throwable)ex).build();
        }
    }

    private void getSheetsFromEntry(ScrapeOptions options, SortedMap<String, ICDFSheet> orderedSheets, ZipFile zip, ZipArchiveEntry entry, String entryName) throws WAImportException, IOException {
        String extension = FilenameUtils.getExtension((String)entryName);
        String name = FilenameUtils.getBaseName((String)entryName);
        DocumentType docType = this.getDocumentType(extension);
        if (DSVScraperFactory.DSV_DOC_TYPE.equals(docType)) {
            DSVScraper scraper = new DSVScraper(this.mCDFService);
            ScrapeResult dsvResult = scraper.scrape(entryName, null, zip.getInputStream(entry), options);
            ICDFSheet sheet = dsvResult.getSheets().values().iterator().next();
            if (null != orderedSheets.put(name, sheet)) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.ZIP_MULTIPLE_SHEETS_SAME_NAME).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
        } else if (this.isExcelDocument(docType)) {
            AbstractExcelScraper scraper = ExcelScraperFactory.XLS_DOC_TYPE.equals(docType) ? new XLSScraper(this.mCDFService, docType) : new XLSXScraper(this.mCDFService, docType);
            ScrapeResult scrapeResult = scraper.scrape(entryName, null, zip.getInputStream(entry), options);
            Map<String, ICDFSheet> sheets = scrapeResult.getSheets();
            this.processSections(name, scrapeResult.getDocument().getSections(), sheets, orderedSheets);
        }
    }

    private void processSections(String name, DocumentSection[] sections, Map<String, ICDFSheet> sheets, SortedMap<String, ICDFSheet> orderedSheets) throws WAImportException {
        for (DocumentSection section : sections) {
            SheetInfo sheetInfo = section.getSheetInfo();
            if (sheetInfo != null && null != orderedSheets.put(name + " - " + section.getName(), sheets.get(sheetInfo.getSheetId()))) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.ZIP_MULTIPLE_SHEETS_SAME_NAME).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
            DocumentSection[] childSections = section.getChildren();
            if (childSections == null) continue;
            this.processSections(name, childSections, sheets, orderedSheets);
        }
    }

    private DocumentType getDocumentType(String extension) {
        if (DSVScraperFactory.DSV_DOC_TYPE.getFileExtensions().contains(extension)) {
            return DSVScraperFactory.DSV_DOC_TYPE;
        }
        if (ExcelScraperFactory.XLS_DOC_TYPE.getFileExtensions().contains(extension)) {
            return ExcelScraperFactory.XLS_DOC_TYPE;
        }
        if (ExcelScraperFactory.XLSX_DOC_TYPE.getFileExtensions().contains(extension)) {
            return ExcelScraperFactory.XLSX_DOC_TYPE;
        }
        if (ExcelScraperFactory.XLSXB_DOC_TYPE.getFileExtensions().contains(extension)) {
            return ExcelScraperFactory.XLSXB_DOC_TYPE;
        }
        if (ExcelScraperFactory.XLSXM_DOC_TYPE.getFileExtensions().contains(extension)) {
            return ExcelScraperFactory.XLSXM_DOC_TYPE;
        }
        return DocumentType.UNKNOWN;
    }

    private boolean isExcelDocument(DocumentType docType) {
        return ExcelScraperFactory.XLS_DOC_TYPE.equals(docType) || ExcelScraperFactory.XLSX_DOC_TYPE.equals(docType) || ExcelScraperFactory.XLSXB_DOC_TYPE.equals(docType) || ExcelScraperFactory.XLSXM_DOC_TYPE.equals(docType);
    }

    private ScrapeResult makeResult(String fileName, String mimeType, SortedMap<String, ICDFSheet> orderedSheets) {
        DocumentModel doc = new DocumentModel(this.getDocumentType().getTypeName(), this.makeTitle(fileName));
        doc.getProperties().put("filename", fileName);
        doc.getProperties().put("mime-type", mimeType);
        ScrapeResult result = new ScrapeResult(doc);
        DocumentSection workbookSection = doc.createSection();
        workbookSection.setName("Workbook");
        workbookSection.setType("zip-workbook");
        for (Map.Entry<String, ICDFSheet> pair : orderedSheets.entrySet()) {
            DocumentSection worksheetSection = workbookSection.createChild();
            worksheetSection.setName(pair.getKey());
            worksheetSection.setSheetInfo(pair.getValue().getSheetInfo());
            worksheetSection.setType("zip-worksheet");
            result.getSheets().put(pair.getValue().getId(), pair.getValue());
        }
        return result;
    }

    private final void discardSheets(Collection<ICDFSheet> sheets) {
        ICDFSheetLibrary sheetLib = this.getCDFService().getSheetLibrary();
        for (ICDFSheet s : sheets) {
            try {
                sheetLib.remove(s.getId());
                s.destroy();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to discard sheet.", (Throwable)ex);
            }
        }
    }
}

