/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.archive;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.scrape.IDocumentScraper;
import com.ibm.neo.dataimport.cdf.scrape.IDocumentScraperFactory;
import com.ibm.neo.dataimport.cdf.scrape.archive.ZipScraper;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.util.Properties;

public class ZipScraperFactory
implements IDocumentScraperFactory {
    public static final String PROP_ZIP_AS_WORKBOOK = "com.ibm.neo.dataimport.cdf.scrape.archive.zip-as-workbook";
    public static final DocumentType ZIP_DOC_TYPE = new DocumentType("zip", "ZIP Archive", new String[]{"zip"}, new String[]{"application/zip"}, false, true);

    @Override
    public DocumentType[] getSupportedDocumentTypes() {
        return this.getSupportedDocumentTypes(null);
    }

    @Override
    public DocumentType[] getSupportedDocumentTypes(Properties config) {
        if (config != null && Boolean.parseBoolean(config.getProperty(PROP_ZIP_AS_WORKBOOK))) {
            return new DocumentType[]{ZIP_DOC_TYPE};
        }
        return new DocumentType[0];
    }

    @Override
    public IDocumentScraper create(DocumentType type, CDFService cdfService) throws WAImportException {
        if (ZIP_DOC_TYPE.equals(type)) {
            return new ZipScraper(cdfService);
        }
        throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.FILE_TYPE_UNSUPPORTED, new Object[]{type.getTypeName()}).withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).withContextAttribute(EImportMessageContext.DOCUMENT_TYPE, (Object)type.getTypeName()).build();
    }
}

