/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.dsv;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeOptions;
import com.ibm.neo.dataimport.cdf.scrape.dsv.AbstractDSVScraper;
import com.ibm.neo.dataimport.cdf.sheet.CDFSheetFactory;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetWriter;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class DSVScraper
extends AbstractDSVScraper {
    public DSVScraper(CDFService cdfService) {
        super(cdfService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICDFSheet parseToSheet(Reader reader, CSVFormat format, ScrapeOptions options) throws IOException, WAImportException {
        ICDFSheet sheet = CDFSheetFactory.createSheet(this.getCDFService());
        boolean success = false;
        try (ICDFSheetWriter sheetWriter = sheet.openWriter();){
            CSVParser parser = new CSVParser(reader, format);
            this.parseLoop(sheetWriter, parser, options);
            success = true;
        }
        finally {
            if (!success) {
                sheet.destroy();
            }
        }
        return sheet;
    }

    private void parseLoop(ICDFSheetWriter writer, CSVParser parser, ScrapeOptions options) throws WAImportException {
        Iterator iter = parser.iterator();
        CSVRecord rec = null;
        int lastNonEmptyPos = 0;
        long recordIndex = -1L;
        try {
            while (iter.hasNext()) {
                rec = (CSVRecord)iter.next();
                ++recordIndex;
                lastNonEmptyPos = -1;
                for (int i = rec.size() - 1; i >= 0; --i) {
                    String s = rec.get(i);
                    if (null == s || s.isEmpty()) continue;
                    lastNonEmptyPos = i;
                    break;
                }
                if (lastNonEmptyPos >= 0) {
                    String[] fields = new String[lastNonEmptyPos + 1];
                    for (int i = 0; i < fields.length; ++i) {
                        fields[i] = rec.get(i);
                    }
                    ICDFCell[] cells = DSVScraper.parseFields(recordIndex, fields, writer.getCellFactory(), options);
                    writer.appendRow(cells);
                    continue;
                }
                if (options.getSkipEmptyRows()) continue;
                writer.appendEmptyRow();
            }
        }
        catch (Exception ex) {
            long lineHint = parser.getCurrentLineNumber();
            String parseErrorMessage = ex instanceof IOException ? ex.getMessage() : null;
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.ILLEGAL_CSV_FORMAT, new Object[]{String.valueOf(lineHint)}).withConditionCode(EImportMessageCode.ILLEGAL_CSV_FORMAT).withContextAttribute(EImportMessageContext.CSV_LINE_NUMBER, (Object)lineHint).withContextAttribute(EImportMessageContext.CSV_BYTE_OFFSET, (Object)parser.getCurrentOffset()).withContextAttributeIfNotNull(EImportMessageContext.CSV_PARSE_ERROR_REASON, (Object)parseErrorMessage).withCause((Throwable)ex).build();
        }
    }
}

