/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.dsv;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.scrape.IDocumentScraper;
import com.ibm.neo.dataimport.cdf.scrape.IDocumentScraperFactory;
import com.ibm.neo.dataimport.cdf.scrape.dsv.DSVScraper;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.util.Properties;

public class DSVScraperFactory
implements IDocumentScraperFactory {
    public static final DocumentType DSV_DOC_TYPE = new DocumentType("dsv", "Delimiter-Separated Value", new String[]{"csv", "tsv", "tab", "txt"}, new String[]{"application/csv", "text/csv", "text/tab-separated-values", "text/plain"}, false, false);

    @Override
    public DocumentType[] getSupportedDocumentTypes() {
        return this.getSupportedDocumentTypes(null);
    }

    @Override
    public DocumentType[] getSupportedDocumentTypes(Properties config) {
        return new DocumentType[]{DSV_DOC_TYPE};
    }

    @Override
    public IDocumentScraper create(DocumentType type, CDFService cdfService) throws WAImportException {
        if (!DSV_DOC_TYPE.equals(type)) {
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.FILE_TYPE_UNSUPPORTED, new Object[]{type.getTypeName()}).withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).withContextAttribute(EImportMessageContext.DOCUMENT_TYPE, (Object)type.getTypeName()).build();
        }
        return new DSVScraper(cdfService);
    }
}

