/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.excel;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.cognos.aurora.core.util.LCID;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.decoration.BorderDecoration;
import com.ibm.neo.dataimport.cdf.decoration.CurrencyDecoration;
import com.ibm.neo.dataimport.cdf.decoration.DateTimeFormatDecoration;
import com.ibm.neo.dataimport.cdf.decoration.DecorationMap;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.dataimport.cdf.decoration.FontStyleDecoration;
import com.ibm.neo.dataimport.cdf.decoration.NumberFormatDecoration;
import com.ibm.neo.dataimport.cdf.scrape.AbstractDocumentScraper;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeOptions;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeResult;
import com.ibm.neo.dataimport.cdf.scrape.excel.FormatCache;
import com.ibm.neo.dataimport.cdf.sheet.CDFSheetFactory;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCellFactory;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetWriter;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.misc.CellRange;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelGeneralNumberFormat;
import org.apache.poi.ss.usermodel.FractionFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcelScraper
extends AbstractDocumentScraper {
    public static final String PROP_HEADER_TEXT = "header-text";
    public static final String PROP_FOOTER_TEXT = "footer-text";
    private static final double TIME_EPOCH_ADJUSTMENT_1900 = 25569.0;
    private static final double TIME_EPOCH_ADJUSTMENT_1904 = 24107.0;
    protected static final int FONT_HEIGHT_PER_POINT = 20;
    private static final Pattern ICU_DATE_SYMBOLS_PAT = Pattern.compile("[GyYMwWDdFEu]");
    private static final Pattern ICU_TIME_SYMBOLS_PAT = Pattern.compile("[aHkKhmsSzZX]");
    private static final Pattern EXCEL_SPECIAL_TIME_SYMBOLS_PAT = Pattern.compile("(?:\\[(?:H+|h+|m+|s+)\\])|(?:s\\.0+)");
    private static final Format GENERAL_NUMBER_FORMAT = new DecimalFormat("#.##########");
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExcelScraper.class);
    private static Method DATAFORMATTER_GETFORMAT_METHOD;
    private static Field INTERNALDECIMALFORMATWITHSCALE_DF_FIELD;
    private static Method DATAFORMATTER_CREATEDATEFORMAT_METHOD;
    protected final DocumentType mDocumentType;
    private final DataFormatter mDataFormatter = new DataFormatter();
    private final Calendar mCalendar = new GregorianCalendar();
    private final FormatCache mFormatCache = new FormatCache();

    protected AbstractExcelScraper(CDFService cdfService, DocumentType documentType) {
        super(cdfService);
        this.mDocumentType = documentType;
    }

    @Override
    public final DocumentType getDocumentType() {
        return this.mDocumentType;
    }

    protected final void discardSheets(ScrapeResult result) {
        ICDFSheetLibrary sheetLib = this.getCDFService().getSheetLibrary();
        for (ICDFSheet s : result.getSheets().values()) {
            try {
                sheetLib.remove(s.getId());
                s.destroy();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to discard sheet", (Throwable)ex);
            }
        }
    }

    protected final Format getFormat(double value, int formatIndex, String formatString) throws WAImportException {
        int secondPartDelim;
        int firstPartDelim = formatString.indexOf(59);
        if (firstPartDelim != -1 && (secondPartDelim = formatString.indexOf(59, firstPartDelim + 1)) != -1) {
            formatString = formatString.substring(0, secondPartDelim);
        }
        Format format = this.mFormatCache.getFormat(formatIndex, formatString);
        try {
            if (null == format) {
                if (DateUtil.isADateFormat((int)formatIndex, (String)(formatString = this.fixForeignTime(formatString))) || this.isAForeignDate(formatString)) {
                    formatString = this.removeDBNum(formatString);
                    formatString = this.quickReplaceImperialFormatting(formatString);
                    format = (Format)DATAFORMATTER_GETFORMAT_METHOD.invoke((Object)this.mDataFormatter, 0.0, formatIndex, formatString, false);
                    if (format == null) {
                        format = (Format)DATAFORMATTER_CREATEDATEFORMAT_METHOD.invoke((Object)this.mDataFormatter, formatString, formatIndex);
                    }
                } else {
                    format = (Format)DATAFORMATTER_GETFORMAT_METHOD.invoke((Object)this.mDataFormatter, value, formatIndex, formatString, false);
                }
                if (format == null) {
                    return format;
                }
                if (format instanceof ExcelGeneralNumberFormat || format instanceof FractionFormat) {
                    format = GENERAL_NUMBER_FORMAT;
                }
                if (format.getClass().getName().equals("org.apache.poi.ss.usermodel.DataFormatter$InternalDecimalFormatWithScale")) {
                    format = (Format)INTERNALDECIMALFORMATWITHSCALE_DF_FIELD.get(format);
                }
                if (null != format) {
                    this.mFormatCache.putFormat(formatIndex, formatString, format);
                }
            }
            return format;
        }
        catch (Exception e) {
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLS_SCRAPER_CELL_FORMATTING).withCause((Throwable)e).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
        }
    }

    private String fixForeignTime(String formatString) {
        if (!(formatString.contains("hh") || formatString.contains("HH") || formatString.contains("mm") || formatString.contains("ss"))) {
            return formatString;
        }
        if (formatString.contains("MM") || formatString.contains("dd") || formatString.contains("yy")) {
            return formatString;
        }
        if (!(formatString.contains("\u6642") || formatString.contains("\u65f6") || formatString.contains("\u5206") || formatString.contains("\uc2dc") || formatString.contains("\ubd84") || this.hasAmPm(formatString))) {
            return formatString;
        }
        String fs = formatString.replaceAll("[\u6642\u65f6\u5206\uc2dc\ubd84]", ":");
        if (!formatString.contains("ss")) {
            fs = fs.substring(0, fs.lastIndexOf(":"));
        }
        fs = fs.replaceAll("[\ucd08\u79d2\"]", "");
        int lowAM = formatString.lastIndexOf("am/pm");
        int capAM = formatString.lastIndexOf("AM/PM");
        int jpnAM = formatString.lastIndexOf("\u5348\u524d");
        int korAM = formatString.lastIndexOf("\uc624\uc804");
        int chnAM = formatString.lastIndexOf("\u4e0a\u5348");
        int amPmPos = -1;
        if (lowAM >= 0) {
            amPmPos = lowAM;
        } else if (capAM >= 0) {
            amPmPos = capAM;
        } else if (jpnAM >= 0) {
            amPmPos = jpnAM;
        } else if (korAM >= 0) {
            amPmPos = korAM;
        } else if (chnAM >= 0) {
            amPmPos = chnAM;
        }
        if (amPmPos == -1) {
            return fs;
        }
        String afterAmPm = formatString.substring(amPmPos, formatString.length());
        if (afterAmPm.contains("hh") || afterAmPm.contains("mm") || afterAmPm.contains("HH") || afterAmPm.contains("ss") || afterAmPm.contains("SS")) {
            return "hh:mm:ss a";
        }
        return formatString;
    }

    private boolean hasAmPm(String formatString) {
        boolean ret = false;
        ret = formatString.contains("AM/PM") && !formatString.contains("am/pm") ? true : !formatString.contains("AM/PM") && formatString.contains("am/pm");
        return ret;
    }

    private String quickReplaceImperialFormatting(String formatString) {
        return formatString.contains("ggge") ? formatString.replaceAll("ggge", "yyyy") : formatString.replaceAll("ge", "yy");
    }

    private String removeDBNum(String formatString) {
        return formatString.replaceAll("\\[DBNum(1|2|3)]", "");
    }

    private boolean isAForeignDate(String formatString) {
        return formatString.contains("\uc77c") || formatString.contains("\uc6d4") || formatString.contains("\ub144") || formatString.contains("\uc2dc") || formatString.contains("\ubd84") || formatString.contains("\u5e74") || formatString.contains("\u6708") || formatString.contains("\u65e5") || formatString.contains("\u6642") || formatString.contains("\u65f6") || formatString.contains("\ubd84") || formatString.contains("[$-411]");
    }

    protected Date parseSerialDate(double serialDate, boolean hasDate, boolean hasTime, boolean use1904windowing) {
        if (hasTime && !hasDate) {
            serialDate = use1904windowing ? (serialDate += 24107.0) : (serialDate += 25569.0);
        }
        if (!DateUtil.isValidExcelDate((double)serialDate)) {
            return null;
        }
        int wholeDays = (int)Math.floor(serialDate);
        int millisInDay = (int)((serialDate - (double)wholeDays) * 8.64E7 + 0.5);
        DateUtil.setCalendar((Calendar)this.mCalendar, (int)wholeDays, (int)millisInDay, (boolean)use1904windowing, (boolean)false);
        return this.mCalendar.getTime();
    }

    protected static boolean parseBoolean(String str) {
        return "true".equals(str) || "1".equals(str);
    }

    protected static boolean hasICUDateFormatSymbols(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        Matcher m = ICU_DATE_SYMBOLS_PAT.matcher(formatString);
        return m.find();
    }

    protected static boolean hasICUTimeFormatSymbols(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        Matcher m = ICU_TIME_SYMBOLS_PAT.matcher(formatString);
        return m.find();
    }

    protected static boolean hasExcelSpecialTimeFormatSymbols(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        Matcher m = EXCEL_SPECIAL_TIME_SYMBOLS_PAT.matcher(formatString);
        return m.find();
    }

    protected static FontStyleDecoration.EUnderlineStyle convertUnderlineStyle(byte underline) {
        switch (underline) {
            case 2: 
            case 34: {
                return FontStyleDecoration.EUnderlineStyle.DOUBLE;
            }
            case 1: 
            case 33: {
                return FontStyleDecoration.EUnderlineStyle.SINGLE;
            }
        }
        return FontStyleDecoration.EUnderlineStyle.NONE;
    }

    protected static BorderDecoration.EBorderStyle convertBorderStyle(short border) {
        switch (border) {
            case 1: {
                return BorderDecoration.EBorderStyle.THIN;
            }
            case 2: {
                return BorderDecoration.EBorderStyle.MEDIUM;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                return BorderDecoration.EBorderStyle.DASH;
            }
            case 4: 
            case 11: 
            case 12: {
                return BorderDecoration.EBorderStyle.DOT;
            }
            case 5: {
                return BorderDecoration.EBorderStyle.THICK;
            }
            case 6: {
                return BorderDecoration.EBorderStyle.DOUBLE;
            }
            case 7: {
                return BorderDecoration.EBorderStyle.HAIR;
            }
        }
        return BorderDecoration.EBorderStyle.NONE;
    }

    protected static String stripLiteralsFromPattern(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        boolean quoteOpened = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            if (chr == '\'') {
                if (quoteOpened) {
                    quoteOpened = false;
                    continue;
                }
                quoteOpened = true;
                continue;
            }
            if (quoteOpened) continue;
            sb.append(chr);
        }
        return sb.toString();
    }

    static CurrencyDecoration buildCurrencyDecoration(String formatString) {
        int firstCurrencySymbolPos = formatString.indexOf(36);
        if (firstCurrencySymbolPos < 0) {
            return null;
        }
        HashSet<Currency> possibleCurrencies = new HashSet<Currency>();
        String symbol = null;
        boolean useISOCodeAsSymbol = false;
        if (firstCurrencySymbolPos > 0 && '[' == formatString.charAt(firstCurrencySymbolPos - 1)) {
            int closingBracketPos = formatString.indexOf(93, firstCurrencySymbolPos);
            if (closingBracketPos < 0) {
                throw new RuntimeException("Malformed format string: " + formatString);
            }
            int dashPos = (formatString = formatString.substring(firstCurrencySymbolPos + 1, closingBracketPos)).indexOf(45);
            if (dashPos > 0) {
                Currency cur;
                ULocale locale;
                String lcidPart = formatString.substring(dashPos + 1);
                symbol = formatString.substring(0, dashPos);
                if (lcidPart != null && lcidPart.length() > 0 && null != (locale = LCID.toLocale((int)Integer.parseInt(lcidPart, 16))) && null != (cur = Currency.getInstance((ULocale)locale))) {
                    possibleCurrencies.add(cur);
                }
            } else {
                useISOCodeAsSymbol = true;
                if (Currency.isAvailable((String)formatString, null, null)) {
                    Currency c = Currency.getInstance((String)formatString);
                    possibleCurrencies.add(c);
                }
            }
        } else if (formatString.startsWith("\"$\"") || formatString.endsWith("\"$\"")) {
            symbol = "$";
        }
        String currencyCode = null;
        String currencySymbol = null;
        if (possibleCurrencies.size() == 1) {
            currencyCode = ((Currency)possibleCurrencies.iterator().next()).getCurrencyCode();
            if (useISOCodeAsSymbol) {
                currencySymbol = "***";
            }
        } else {
            currencySymbol = symbol != null ? symbol : "\u00a4";
        }
        if (null != currencyCode || null != currencySymbol) {
            return new CurrencyDecoration(currencyCode, currencySymbol);
        }
        return null;
    }

    static {
        try {
            DATAFORMATTER_GETFORMAT_METHOD = DataFormatter.class.getDeclaredMethod("getFormat", Double.TYPE, Integer.TYPE, String.class, Boolean.TYPE);
            DATAFORMATTER_GETFORMAT_METHOD.setAccessible(true);
            Class<?> internalDecimalFormatWithScaleClass = DataFormatter.class.getClassLoader().loadClass("org.apache.poi.ss.usermodel.DataFormatter$InternalDecimalFormatWithScale");
            INTERNALDECIMALFORMATWITHSCALE_DF_FIELD = internalDecimalFormatWithScaleClass.getDeclaredField("df");
            INTERNALDECIMALFORMATWITHSCALE_DF_FIELD.setAccessible(true);
            DATAFORMATTER_CREATEDATEFORMAT_METHOD = DataFormatter.class.getDeclaredMethod("createDateFormat", String.class, Double.TYPE);
            DATAFORMATTER_CREATEDATEFORMAT_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error: " + e.toString());
        }
    }

    protected final class WorksheetHandler {
        private final ScrapeResult mResult;
        private final ScrapeOptions mOptions;
        private final DocumentSection mWorksheetSection;
        private final ICDFSheet mSheet;
        private final ICDFSheetWriter mSheetWriter;
        private final ICDFCellFactory mCellFactory;
        private int mCurrentRowNumber = -1;
        private boolean mCurrentRowNonEmpty = false;
        private final ArrayList<ICDFCell> mCurrentRowCells = new ArrayList();
        private final ArrayList<DecorationMap> mLastDecorations = new ArrayList();

        public int getmCurrentRowNumber() {
            return this.mCurrentRowNumber;
        }

        public WorksheetHandler(ScrapeResult result, ScrapeOptions options, DocumentSection workbookSection, String worksheetName) throws WAImportException {
            this.mResult = result;
            this.mOptions = options;
            try {
                this.mSheet = CDFSheetFactory.createSheet(AbstractExcelScraper.this.getCDFService());
                this.mSheetWriter = this.mSheet.openWriter();
                this.mCellFactory = this.mSheetWriter.getCellFactory();
            }
            catch (IOException ex) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLS_SCRAPER_IO_ERROR).withConditionCode(EImportMessageCode.INTERNAL_ERROR).withCause((Throwable)ex).build();
            }
            this.mWorksheetSection = workbookSection.createChild();
            this.mWorksheetSection.setName(worksheetName);
            this.mWorksheetSection.setType("excel-worksheet");
        }

        public void handleHeaderText(String headerText) {
            if (null != headerText && headerText.length() > 0) {
                this.mWorksheetSection.getProperties().put(AbstractExcelScraper.PROP_HEADER_TEXT, headerText);
            }
        }

        public void handleFooterText(String footerText) {
            if (null != footerText && footerText.length() > 0) {
                this.mWorksheetSection.getProperties().put(AbstractExcelScraper.PROP_FOOTER_TEXT, footerText);
            }
        }

        public void handleStartRow(int row) throws WAImportException {
            if (row != this.mCurrentRowNumber + 1) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_ROW_NOT_FOUND, new Object[]{this.mCurrentRowNumber + 1, row}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            this.mCurrentRowNumber = row;
            this.mCurrentRowCells.clear();
            this.mCurrentRowNonEmpty = false;
        }

        public void handleEndRow(int row) throws WAImportException {
            this.checkRow(row);
            try {
                if (this.mCurrentRowNonEmpty) {
                    this.padRowTo(this.mLastDecorations.size());
                    this.mSheetWriter.appendRow(this.mCurrentRowCells.toArray(new ICDFCell[this.mCurrentRowCells.size()]));
                } else if (!this.mOptions.getSkipEmptyRows()) {
                    this.mSheetWriter.appendEmptyRow();
                }
            }
            catch (IOException ex) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLS_SCRAPER_IO_ERROR).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
        }

        public void handleBlankCell(int row, int column, DecorationMap decorations) throws WAImportException {
            this.checkCell(row, column);
            this.padRowTo(column);
            decorations = this.resolveCellDecorations(row, column, decorations);
            this.mCurrentRowCells.add(this.mCellFactory.createNull(EDataType.STRING, decorations));
        }

        public void handleStringCell(int row, int column, String value, DecorationMap decorations) throws WAImportException {
            this.checkCell(row, column);
            this.padRowTo(column);
            int lengthLimit = this.mOptions.getFieldStringLengthLimit(column);
            if (lengthLimit > 0 && null != value && value.length() > lengthLimit) {
                value = value.substring(0, lengthLimit);
            }
            decorations = this.resolveCellDecorations(row, column, decorations);
            this.mCurrentRowCells.add(this.mCellFactory.createString(value, decorations));
            this.mCurrentRowNonEmpty = true;
        }

        public void handleBooleanCell(int row, int column, boolean value, DecorationMap decorations) throws WAImportException {
            this.checkCell(row, column);
            this.padRowTo(column);
            decorations = this.resolveCellDecorations(row, column, decorations);
            this.mCurrentRowCells.add(this.mCellFactory.createBoolean(value, decorations));
            this.mCurrentRowNonEmpty = true;
        }

        public void handleNumericCell(int row, int column, double value, DecorationMap decorations) throws WAImportException {
            String formatPattern;
            this.checkCell(row, column);
            this.padRowTo(column);
            decorations = this.resolveCellDecorations(row, column, decorations);
            double flooredValue = Math.floor(value);
            NumberFormatDecoration nfd = (NumberFormatDecoration)decorations.get(EDecorationType.NUMBER_FORMAT);
            boolean hasFractionalDigits = false;
            if (null != nfd && null != (formatPattern = nfd.getFormatPattern())) {
                hasFractionalDigits = formatPattern.contains(".0");
            }
            if (!hasFractionalDigits && value == flooredValue) {
                if (flooredValue > 2.147483647E9 || flooredValue < -2.147483648E9) {
                    this.mCurrentRowCells.add(this.mCellFactory.createInt64((long)flooredValue, decorations));
                } else if (flooredValue > 32767.0 || flooredValue < -32768.0) {
                    this.mCurrentRowCells.add(this.mCellFactory.createInt32((int)flooredValue, decorations));
                } else if (flooredValue > 127.0 || flooredValue < -128.0) {
                    this.mCurrentRowCells.add(this.mCellFactory.createInt16((short)flooredValue, decorations));
                } else {
                    this.mCurrentRowCells.add(this.mCellFactory.createInt8((byte)flooredValue, decorations));
                }
            } else {
                this.mCurrentRowCells.add(this.mCellFactory.createFloat64(value, decorations));
            }
            this.mCurrentRowNonEmpty = true;
        }

        public void handleDateCell(int row, int column, Date value, DecorationMap decorations) throws WAImportException {
            this.checkCell(row, column);
            this.padRowTo(column);
            decorations = this.resolveCellDecorations(row, column, decorations);
            DateTimeFormatDecoration dtf = (DateTimeFormatDecoration)decorations.get(EDecorationType.DATETIME_FORMAT);
            if (null == dtf) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_CELL_MISSING_DECORATIONS).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            if (dtf.hasDateFields()) {
                if (dtf.hasTimeFields()) {
                    this.mCurrentRowCells.add(this.mCellFactory.createTimestamp(value, decorations));
                } else {
                    this.mCurrentRowCells.add(this.mCellFactory.createDate(value, decorations));
                }
            } else if (dtf.hasTimeFields()) {
                this.mCurrentRowCells.add(this.mCellFactory.createTime(value, decorations));
            } else {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_CELL_WITHOUT_DATE).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            this.mCurrentRowNonEmpty = true;
        }

        public void handleMergedCellArea(int groupId, CellRange range) {
        }

        public void finish(boolean discardSheet) throws WAImportException {
            try {
                this.mSheetWriter.close();
                if (discardSheet) {
                    this.mSheet.destroy();
                } else {
                    this.mSheet.saveMetadata();
                    AbstractExcelScraper.this.getCDFService().getSheetLibrary().store(this.mSheet);
                    this.mWorksheetSection.setSheetInfo(this.mSheet.getSheetInfo());
                    this.mResult.getSheets().put(this.mSheet.getId(), this.mSheet);
                }
            }
            catch (IOException ex) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLS_SCRAPER_IO_ERROR).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
        }

        private void padRowTo(int column) throws WAImportException {
            while (this.mCurrentRowCells.size() < column) {
                this.handleBlankCell(this.mCurrentRowNumber, this.mCurrentRowCells.size(), null);
            }
        }

        private void checkRow(int row) throws WAImportException {
            if (row != this.mCurrentRowNumber) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_ROW_PROCESSING, new Object[]{this.mCurrentRowNumber, row}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
        }

        private void checkCell(int row, int col) throws WAImportException {
            this.checkRow(row);
            if (col < this.mCurrentRowCells.size()) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_CELL_PROCESSING, new Object[]{row, col}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
        }

        private DecorationMap resolveCellDecorations(int row, int column, DecorationMap decorations) {
            if (null == decorations && column < this.mLastDecorations.size()) {
                decorations = this.mLastDecorations.get(column);
            }
            if (null == decorations) {
                return null;
            }
            while (this.mLastDecorations.size() <= column) {
                this.mLastDecorations.add(null);
            }
            this.mLastDecorations.set(column, decorations);
            return decorations;
        }
    }
}

