/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.excel;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.scrape.IDocumentScraper;
import com.ibm.neo.dataimport.cdf.scrape.IDocumentScraperFactory;
import com.ibm.neo.dataimport.cdf.scrape.excel.XLSScraper;
import com.ibm.neo.dataimport.cdf.scrape.excel.XLSXScraper;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.util.Properties;

public class ExcelScraperFactory
implements IDocumentScraperFactory {
    public static final DocumentType XLS_DOC_TYPE = new DocumentType("excel97", "Excel 97 Spreadsheet", new String[]{"xls", "xlm"}, new String[]{"application/vnd.ms-excel"}, true, false);
    public static final DocumentType XLSX_DOC_TYPE = new DocumentType("excel2007", "Excel 2007 Workbook", new String[]{"xlsx"}, new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}, true, true);
    public static final DocumentType XLSXM_DOC_TYPE = new DocumentType("excel2007-macro", "Excel 2007 Workbook with Macros", new String[]{"xlsm"}, new String[]{"application/vnd.ms-excel.sheet.macroEnabled.12"}, true, true);
    public static final DocumentType XLSXB_DOC_TYPE = new DocumentType("excel2007-bin", "Excel 2007 Binary Workbook", new String[]{"xlsb"}, new String[]{"application/vnd.ms-excel.sheet.binary.macroEnabled.12"}, true, true);

    @Override
    public DocumentType[] getSupportedDocumentTypes() {
        return this.getSupportedDocumentTypes(null);
    }

    @Override
    public DocumentType[] getSupportedDocumentTypes(Properties config) {
        return new DocumentType[]{XLS_DOC_TYPE, XLSX_DOC_TYPE, XLSXM_DOC_TYPE, XLSXB_DOC_TYPE};
    }

    @Override
    public IDocumentScraper create(DocumentType type, CDFService cdfService) throws WAImportException {
        if (XLS_DOC_TYPE.equals(type)) {
            return new XLSScraper(cdfService, type);
        }
        if (XLSX_DOC_TYPE.equals(type) || XLSXB_DOC_TYPE.equals(type) || XLSXM_DOC_TYPE.equals(type)) {
            return new XLSXScraper(cdfService, type);
        }
        throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.FILE_TYPE_UNSUPPORTED, new Object[]{type.getTypeName()}).withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).withContextAttribute(EImportMessageContext.DOCUMENT_TYPE, (Object)type.getTypeName()).build();
    }
}

