/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.excel;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.decoration.AlignmentDecoration;
import com.ibm.neo.dataimport.cdf.decoration.BorderDecoration;
import com.ibm.neo.dataimport.cdf.decoration.CurrencyDecoration;
import com.ibm.neo.dataimport.cdf.decoration.DateTimeFormatDecoration;
import com.ibm.neo.dataimport.cdf.decoration.DecorationMap;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.dataimport.cdf.decoration.FillDecoration;
import com.ibm.neo.dataimport.cdf.decoration.FontStyleDecoration;
import com.ibm.neo.dataimport.cdf.decoration.NumberFormatDecoration;
import com.ibm.neo.dataimport.cdf.decoration.RGBColor;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeOptions;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeResult;
import com.ibm.neo.dataimport.cdf.scrape.excel.AbstractExcelScraper;
import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.misc.CellRange;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.util.Holder;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.OldFileFormatException;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.RecordFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSScraper
extends AbstractExcelScraper {
    private static final int FORMULA_CACHED_BOOLEAN_TYPE = 4;
    private static final int FORMULA_CACHED_ERROR_CODE_TYPE = 5;
    private static final int FORMULA_CACHED_STRING_TYPE = 1;
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK"};
    private static final FileMagic[] SUPPORTED_MAGICS = new FileMagic[]{FileMagic.OLE2};
    private static final Logger LOGGER = LoggerFactory.getLogger(XLSScraper.class);

    public XLSScraper(CDFService cdfService, DocumentType documentType) {
        super(cdfService, documentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrapeResult scrape(String fileName, String mimeType, File file, ScrapeOptions options) throws WAImportException {
        ScrapeResult scrapeResult;
        if (null == fileName) {
            throw new NullArgumentException("fileName");
        }
        if (null == file) {
            throw new NullArgumentException("file");
        }
        if (null == options) {
            throw new NullArgumentException("options");
        }
        FileInputStream fin = new FileInputStream(file);
        try {
            scrapeResult = this.scrape(fileName, mimeType, fin, options);
        }
        catch (Throwable throwable) {
            try {
                fin.close();
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.error("IO Error", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLS_SCRAPER_IO_ERROR).withConditionCode(EImportMessageCode.INTERNAL_ERROR).withCause((Throwable)ex).build();
            }
        }
        fin.close();
        return scrapeResult;
    }

    @Override
    public ScrapeResult scrape(String fileName, String mimeType, InputStream input, final ScrapeOptions options) throws WAImportException {
        if (null == fileName) {
            throw new NullArgumentException("fileName");
        }
        if (null == input) {
            throw new NullArgumentException("input");
        }
        if (null == options) {
            throw new NullArgumentException("options");
        }
        DocumentModel doc = new DocumentModel(this.getDocumentType().getTypeName(), this.makeTitle(fileName));
        final ScrapeResult result = new ScrapeResult(doc);
        doc.getProperties().put("filename", fileName);
        if (null != mimeType) {
            doc.getProperties().put("mime-type", mimeType);
        }
        final DocumentSection workbookSection = doc.createSection();
        workbookSection.setName("Workbook");
        workbookSection.setType("excel-workbook");
        boolean success = false;
        try {
            InputStream pbInput = FileMagic.prepareToCheckMagic((InputStream)input);
            FileMagic detectedMagic = FileMagic.valueOf((InputStream)pbInput);
            if (FileMagic.UNKNOWN.equals((Object)detectedMagic)) {
                LOGGER.error("Detected an unknown file magic - this is not a valid XLS file.");
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLS).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
            if (!Arrays.asList(SUPPORTED_MAGICS).contains(detectedMagic)) {
                LOGGER.error("Detected an unsupported file magic ({}) - we cannot parse this XLS file format.");
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.FILE_TYPE_UNSUPPORTED, new Object[]{detectedMagic.name()}).withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).build();
            }
            POIFSReader fsReader = new POIFSReader();
            final Holder exceptionHolder = new Holder();
            final MutableBoolean workbookFound = new MutableBoolean(false);
            fsReader.registerListener(new POIFSReaderListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processPOIFSReaderEvent(POIFSReaderEvent event) {
                    String docName = event.getName();
                    try (DocumentInputStream docStream = event.getStream();){
                        if (workbookFound.booleanValue()) {
                            return;
                        }
                        if ("Book".equals(docName)) {
                            LOGGER.error("The XLS document appears to be in the Excel 5/7 (BIFF5) format");
                            exceptionHolder.set((Object)WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.EXCEL_BIFF5_UNSUPPORTED).withConditionCode(EImportMessageCode.EXCEL_BIFF5_UNSUPPORTED).build());
                            return;
                        }
                        for (String name : WORKBOOK_DIR_ENTRY_NAMES) {
                            if (!name.equals(docName)) continue;
                            try {
                                workbookFound.setValue(true);
                                XLSScraper.this.scrapeWorkbook(docStream, workbookSection, options, result);
                            }
                            catch (Exception ex) {
                                exceptionHolder.set((Object)ex);
                            }
                            break;
                        }
                    }
                }
            });
            fsReader.read(pbInput);
            Throwable ex = (Throwable)exceptionHolder.get();
            if (null != ex) {
                if (ex instanceof WAImportException) {
                    throw (WAImportException)ex;
                }
                throw WAImportException.newBuilder().withMessage(ex.getMessage()).withCause(ex).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            success = true;
        }
        catch (IOException ex) {
            LOGGER.error("IO Error", (Throwable)ex);
            throw WAImportException.newBuilder().withMessage("IO Error").withConditionCode(EImportMessageCode.INTERNAL_ERROR).withCause((Throwable)ex).build();
        }
        finally {
            if (!success) {
                this.discardSheets(result);
            }
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scrapeWorkbook(DocumentInputStream workbookStream, DocumentSection workbookSection, ScrapeOptions options, ScrapeResult result) throws Exception {
        boolean bl;
        HSSFRequest req = new HSSFRequest();
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRecordHandler handler = new HSSFRecordHandler(result, options, workbookSection);
        boolean success = false;
        req.addListenerForAllRecords((HSSFListener)handler);
        try {
            factory.abortableProcessEvents(req, (InputStream)workbookStream);
            success = true;
            bl = !success;
        }
        catch (OldFileFormatException ex) {
            try {
                LOGGER.error("The file format is too old", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.FILE_TYPE_OLD).withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).withCause((Throwable)ex).build();
                catch (EncryptedDocumentException ex2) {
                    LOGGER.error("The document is protected by a password", (Throwable)ex2);
                    throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.ENCRYPTION_NOT_SUPPORTED).withConditionCode(EImportMessageCode.ENCRYPTION_NOT_SUPPORTED).withCause((Throwable)ex2).build();
                }
                catch (RecordFormatException ex3) {
                    if (ex3.getMessage().contains("Unknown encryption info")) {
                        LOGGER.error("The document is protected by a password", (Throwable)ex3);
                        throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.ENCRYPTION_NOT_SUPPORTED).withConditionCode(EImportMessageCode.ENCRYPTION_NOT_SUPPORTED).withCause((Throwable)ex3).build();
                    }
                    LOGGER.error("The file does not appear to be a valid XLS document or it may contain unsupported features", (Throwable)ex3);
                    throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_OR_UNSUPPORTED_FEATURES).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).withCause((Throwable)ex3).build();
                }
                catch (HSSFUserException ex4) {
                    Throwable reason = ex4.getReason();
                    LOGGER.error("Failed to process document", reason);
                    if (!(reason instanceof Exception)) throw WAImportException.newBuilder().withMessage(reason.getMessage()).withConditionCode(EImportMessageCode.INTERNAL_ERROR).withCause(reason).build();
                    throw (Exception)reason;
                }
            }
            catch (Throwable throwable) {
                handler.finishCurrentSheet(!success);
                throw throwable;
            }
        }
        handler.finishCurrentSheet(bl);
    }

    private static AlignmentDecoration.EHorizontalAlignment convertHAlignment(short alignment) {
        switch (alignment) {
            case 1: {
                return AlignmentDecoration.EHorizontalAlignment.LEFT;
            }
            case 2: 
            case 6: {
                return AlignmentDecoration.EHorizontalAlignment.CENTER;
            }
            case 3: {
                return AlignmentDecoration.EHorizontalAlignment.RIGHT;
            }
            case 4: 
            case 5: {
                return AlignmentDecoration.EHorizontalAlignment.JUSITFY;
            }
        }
        return AlignmentDecoration.EHorizontalAlignment.GENERAL;
    }

    private static AlignmentDecoration.EVerticalAlignment convertVAlignment(short alignment) {
        switch (alignment) {
            case 1: {
                return AlignmentDecoration.EVerticalAlignment.CENTER;
            }
            case 3: {
                return AlignmentDecoration.EVerticalAlignment.JUSTIFY;
            }
            case 2: {
                return AlignmentDecoration.EVerticalAlignment.BOTTOM;
            }
        }
        return AlignmentDecoration.EVerticalAlignment.TOP;
    }

    public static boolean notInRange(int x, int max, int min) {
        return x < min || x > max;
    }

    private final class HSSFRecordHandler
    extends AbortableHSSFListener {
        private final ScrapeResult mResult;
        private final ScrapeOptions mOptions;
        private final DocumentSection mWorkbookSection;
        private final List<String> mWorksheetNames = new ArrayList<String>();
        private int mCurrentWorksheetIndex = -1;
        private AbstractExcelScraper.WorksheetHandler mWorksheetHandler;
        private short mLastSID;
        private final Map<Integer, FormatRecord> mUserFormatRecords = new HashMap<Integer, FormatRecord>();
        private final List<ExtendedFormatRecord> mXFormatRecords = new ArrayList<ExtendedFormatRecord>();
        private final List<FontRecord> mFontRecords = new ArrayList<FontRecord>();
        private PaletteRecord mPaletteRecord = new PaletteRecord();
        private SSTRecord mLastSSTRecord;
        private FormulaRecord mLastFormulaRecord;
        private final List<ColumnInfoRecord> mColumnInfoRecords = new ArrayList<ColumnInfoRecord>();
        private boolean mRowStarted = false;
        private int mLastRowNumber = -1;
        private boolean mUse1904windowing = false;
        private int reservedFormatLowerRange = 23;
        private int reservedFormatHigherRange = 36;

        public HSSFRecordHandler(ScrapeResult result, ScrapeOptions options, DocumentSection workbookSection) {
            this.mResult = result;
            this.mOptions = options;
            this.mWorkbookSection = workbookSection;
        }

        public short abortableProcessRecord(Record rec) throws HSSFUserException {
            try {
                switch (rec.getSid()) {
                    case 34: {
                        this.handleDateWindow1904Record((DateWindow1904Record)rec);
                        break;
                    }
                    case 2057: {
                        this.handleBOFRecord((BOFRecord)rec);
                        break;
                    }
                    case 133: {
                        this.handleBoundSheetRecord((BoundSheetRecord)rec);
                        break;
                    }
                    case 20: {
                        this.handleHeaderRecord((HeaderRecord)rec);
                        break;
                    }
                    case 21: {
                        this.handleFooterRecord((FooterRecord)rec);
                        break;
                    }
                    case 146: {
                        this.handlePaletteRecord((PaletteRecord)rec);
                        break;
                    }
                    case 125: {
                        this.handleColumnInfoRecord((ColumnInfoRecord)rec);
                        break;
                    }
                    case 513: {
                        this.handleBlankRecord((BlankRecord)rec);
                        break;
                    }
                    case 190: {
                        this.handleMulBlankRecord((MulBlankRecord)rec);
                        break;
                    }
                    case 517: {
                        this.handleBoolErrRecord((BoolErrRecord)rec);
                        break;
                    }
                    case 515: {
                        this.handleNumberRecord((NumberRecord)rec);
                        break;
                    }
                    case 519: {
                        this.handleStringRecord((StringRecord)rec);
                        break;
                    }
                    case 252: {
                        this.handleSSTRecord((SSTRecord)rec);
                        break;
                    }
                    case 253: {
                        this.handleLabelSSTRecord((LabelSSTRecord)rec);
                        break;
                    }
                    case 6: {
                        this.handleFormulaRecord((FormulaRecord)rec);
                        break;
                    }
                    case 1054: {
                        this.handleFormatRecord((FormatRecord)rec);
                        break;
                    }
                    case 224: {
                        this.handleExtendedFormatRecord((ExtendedFormatRecord)rec);
                        break;
                    }
                    case 49: {
                        this.handleFontRecord((FontRecord)rec);
                        break;
                    }
                    case 229: {
                        this.handleMergeCellsRecord((MergeCellsRecord)rec);
                        break;
                    }
                }
                this.mLastSID = rec.getSid();
            }
            catch (Exception ex) {
                throw new HSSFUserException((Throwable)ex);
            }
            return 0;
        }

        private void finishCurrentSheet(boolean discard) throws WAImportException {
            if (null != this.mWorksheetHandler) {
                if (this.mRowStarted) {
                    this.mWorksheetHandler.handleEndRow(this.mLastRowNumber);
                    this.mRowStarted = false;
                }
                this.mWorksheetHandler.finish(discard);
                this.mWorksheetHandler = null;
            }
        }

        private void handleDateWindow1904Record(DateWindow1904Record rec) {
            this.mUse1904windowing = rec.getWindowing() != 0;
        }

        private void handleBOFRecord(BOFRecord rec) throws Exception {
            if (rec.getType() == 16) {
                this.finishCurrentSheet(false);
                ++this.mCurrentWorksheetIndex;
                if (this.mCurrentWorksheetIndex >= this.mWorksheetNames.size()) {
                    LOGGER.error("The file does not appear to be a valid XLS document - BOFRecord has no corresponding BoundSheetRecord");
                    throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLS).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
                }
                this.mWorksheetHandler = new AbstractExcelScraper.WorksheetHandler(this.mResult, this.mOptions, this.mWorkbookSection, this.mWorksheetNames.get(this.mCurrentWorksheetIndex));
                this.mColumnInfoRecords.clear();
                this.mLastFormulaRecord = null;
                this.mRowStarted = false;
                this.mLastRowNumber = -1;
            }
        }

        private void handleBoundSheetRecord(BoundSheetRecord rec) throws Exception {
            this.mWorksheetNames.add(rec.getSheetname());
        }

        private void handleHeaderRecord(HeaderRecord rec) throws Exception {
            this.checkWorksheetHandler();
            this.mWorksheetHandler.handleHeaderText(rec.getText());
        }

        private void handleFooterRecord(FooterRecord rec) throws Exception {
            this.checkWorksheetHandler();
            this.mWorksheetHandler.handleFooterText(rec.getText());
        }

        private void handlePaletteRecord(PaletteRecord rec) throws Exception {
            this.mPaletteRecord = rec;
        }

        private void handleColumnInfoRecord(ColumnInfoRecord rec) throws Exception {
            this.mColumnInfoRecords.add(rec);
        }

        private void handleBlankRecord(BlankRecord rec) throws Exception {
            this.checkWorksheetHandler();
            this.handleRowNumber(rec.getRow());
            Holder decorationsHolder = new Holder();
            this.processFormatAndDecorations(rec.getXFIndex(), false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
            this.mWorksheetHandler.handleBlankCell(rec.getRow(), rec.getColumn(), (DecorationMap)decorationsHolder.get());
        }

        private void handleMulBlankRecord(MulBlankRecord rec) throws Exception {
            this.checkWorksheetHandler();
            this.handleRowNumber(rec.getRow());
            for (int i = 0; i < rec.getNumColumns(); ++i) {
                Holder decorationsHolder = new Holder();
                this.processFormatAndDecorations(rec.getXFAt(i), false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
                this.mWorksheetHandler.handleBlankCell(rec.getRow(), rec.getFirstColumn() + i, (DecorationMap)decorationsHolder.get());
            }
        }

        private void handleBoolErrRecord(BoolErrRecord rec) throws Exception {
            this.checkWorksheetHandler();
            this.handleRowNumber(rec.getRow());
            Holder decorationsHolder = new Holder();
            this.processFormatAndDecorations(rec.getXFIndex(), false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
            if (rec.isBoolean()) {
                this.mWorksheetHandler.handleBooleanCell(rec.getRow(), rec.getColumn(), rec.getBooleanValue(), (DecorationMap)decorationsHolder.get());
            } else {
                this.mWorksheetHandler.handleBlankCell(rec.getRow(), rec.getColumn(), (DecorationMap)decorationsHolder.get());
            }
        }

        private void handleNumberRecord(NumberRecord rec) throws Exception {
            this.checkWorksheetHandler();
            this.handleRowNumber(rec.getRow());
            Holder decorationsHolder = new Holder();
            Holder formatHolder = new Holder();
            this.processFormatAndDecorations(rec.getXFIndex(), true, rec.getValue(), (Holder<DecorationMap>)decorationsHolder, (Holder<Format>)formatHolder);
            if (((DecorationMap)decorationsHolder.get()).containsKey(EDecorationType.DATETIME_FORMAT)) {
                DateTimeFormatDecoration dtf = (DateTimeFormatDecoration)((DecorationMap)decorationsHolder.get()).get(EDecorationType.DATETIME_FORMAT);
                Date dateValue = XLSScraper.this.parseSerialDate(rec.getValue(), dtf.hasDateFields(), dtf.hasTimeFields(), this.mUse1904windowing);
                if (null != dateValue) {
                    this.mWorksheetHandler.handleDateCell(rec.getRow(), rec.getColumn(), dateValue, (DecorationMap)decorationsHolder.get());
                }
            } else if (((DecorationMap)decorationsHolder.get()).containsKey(EDecorationType.NUMBER_FORMAT)) {
                this.mWorksheetHandler.handleNumericCell(rec.getRow(), rec.getColumn(), rec.getValue(), (DecorationMap)decorationsHolder.get());
            } else if (null != formatHolder.get()) {
                this.mWorksheetHandler.handleStringCell(rec.getRow(), rec.getColumn(), ((Format)formatHolder.get()).format(rec.getValue()), (DecorationMap)decorationsHolder.get());
            } else {
                this.mWorksheetHandler.handleNumericCell(rec.getRow(), rec.getColumn(), rec.getValue(), (DecorationMap)decorationsHolder.get());
            }
        }

        private void handleSSTRecord(SSTRecord rec) throws Exception {
            this.mLastSSTRecord = rec;
        }

        private void handleLabelSSTRecord(LabelSSTRecord rec) throws Exception {
            this.checkWorksheetHandler();
            this.handleRowNumber(rec.getRow());
            Holder decorationsHolder = new Holder();
            this.processFormatAndDecorations(rec.getXFIndex(), false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
            this.mWorksheetHandler.handleStringCell(rec.getRow(), rec.getColumn(), this.mLastSSTRecord.getString(rec.getSSTIndex()).getString(), (DecorationMap)decorationsHolder.get());
        }

        private void handleFormulaRecord(FormulaRecord rec) throws Exception {
            this.checkWorksheetHandler();
            this.handleRowNumber(rec.getRow());
            Holder decorationsHolder = new Holder();
            int resultType = rec.getCachedResultType();
            if (4 == resultType) {
                this.processFormatAndDecorations(rec.getXFIndex(), false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
                this.mWorksheetHandler.handleBooleanCell(rec.getRow(), rec.getColumn(), rec.getCachedBooleanValue(), (DecorationMap)decorationsHolder.get());
            } else if (5 == resultType) {
                this.processFormatAndDecorations(rec.getXFIndex(), false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
                this.mWorksheetHandler.handleBlankCell(rec.getRow(), rec.getColumn(), (DecorationMap)decorationsHolder.get());
            } else if (1 == resultType) {
                if (rec.hasCachedResultString()) {
                    this.mLastFormulaRecord = rec;
                } else {
                    this.processFormatAndDecorations(rec.getXFIndex(), false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
                    this.mWorksheetHandler.handleStringCell(rec.getRow(), rec.getColumn(), "", (DecorationMap)decorationsHolder.get());
                }
            } else {
                Holder formatHolder = new Holder();
                this.processFormatAndDecorations(rec.getXFIndex(), true, rec.getValue(), (Holder<DecorationMap>)decorationsHolder, (Holder<Format>)formatHolder);
                if (((DecorationMap)decorationsHolder.get()).containsKey(EDecorationType.DATETIME_FORMAT)) {
                    DateTimeFormatDecoration dtf = (DateTimeFormatDecoration)((DecorationMap)decorationsHolder.get()).get(EDecorationType.DATETIME_FORMAT);
                    Date dateValue = XLSScraper.this.parseSerialDate(rec.getValue(), dtf.hasDateFields(), dtf.hasTimeFields(), this.mUse1904windowing);
                    if (null != dateValue) {
                        this.mWorksheetHandler.handleDateCell(rec.getRow(), rec.getColumn(), dateValue, (DecorationMap)decorationsHolder.get());
                    }
                } else if (((DecorationMap)decorationsHolder.get()).containsKey(EDecorationType.NUMBER_FORMAT)) {
                    this.mWorksheetHandler.handleNumericCell(rec.getRow(), rec.getColumn(), rec.getValue(), (DecorationMap)decorationsHolder.get());
                } else if (null != formatHolder.get()) {
                    this.mWorksheetHandler.handleStringCell(rec.getRow(), rec.getColumn(), ((Format)formatHolder.get()).format(rec.getValue()), (DecorationMap)decorationsHolder.get());
                } else {
                    this.mWorksheetHandler.handleNumericCell(rec.getRow(), rec.getColumn(), rec.getValue(), (DecorationMap)decorationsHolder.get());
                }
            }
        }

        private void handleStringRecord(StringRecord rec) throws Exception {
            this.checkWorksheetHandler();
            if (6 == this.mLastSID || 1212 == this.mLastSID) {
                Holder decorationsHolder = new Holder();
                this.processFormatAndDecorations(this.mLastFormulaRecord.getXFIndex(), false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
                this.mWorksheetHandler.handleStringCell(this.mLastFormulaRecord.getRow(), this.mLastFormulaRecord.getColumn(), rec.getString(), (DecorationMap)decorationsHolder.get());
            }
        }

        private void handleFormatRecord(FormatRecord rec) throws Exception {
            this.mUserFormatRecords.put(rec.getIndexCode(), rec);
        }

        private void handleExtendedFormatRecord(ExtendedFormatRecord rec) throws Exception {
            this.mXFormatRecords.add(rec);
        }

        private void handleFontRecord(FontRecord rec) throws Exception {
            this.mFontRecords.add(rec);
        }

        private void handleMergeCellsRecord(MergeCellsRecord rec) throws Exception {
            this.checkWorksheetHandler();
            for (short i = 0; i < rec.getNumAreas(); i = (short)(i + 1)) {
                CellRangeAddress rangeAddress = rec.getAreaAt((int)i);
                CellRange range = CellRange.withCorners((long)rangeAddress.getFirstRow(), (int)rangeAddress.getFirstColumn(), (long)rangeAddress.getLastRow(), (int)rangeAddress.getLastColumn());
                this.mWorksheetHandler.handleMergedCellArea(i, range);
            }
        }

        private void handleRowNumber(int rowNumber) throws Exception {
            this.checkWorksheetHandler();
            if (rowNumber == this.mLastRowNumber) {
                return;
            }
            if (this.mRowStarted) {
                this.mWorksheetHandler.handleEndRow(this.mLastRowNumber);
            } else {
                this.mRowStarted = true;
            }
            for (int i = this.mLastRowNumber + 1; i < rowNumber; ++i) {
                this.mWorksheetHandler.handleStartRow(i);
                this.mWorksheetHandler.handleEndRow(i);
            }
            this.mWorksheetHandler.handleStartRow(rowNumber);
            this.mLastRowNumber = rowNumber;
        }

        private void processFormatAndDecorations(int xfIndex, boolean hasNumber, double dblValue, Holder<DecorationMap> outDecorations, Holder<Format> outFormat) throws WAImportException {
            String formatStr;
            DecorationMap decorations = new DecorationMap();
            ExtendedFormatRecord xformat = this.mXFormatRecords.get(xfIndex);
            FontRecord font = this.getFontRecordAt(xformat.getFontIndex());
            Format format = null;
            if (hasNumber && (formatStr = this.getFormatStringAt(xformat.getFormatIndex())) != null) {
                format = XLSScraper.this.getFormat(dblValue, xformat.getFormatIndex(), formatStr);
                if (format instanceof DecimalFormat) {
                    CurrencyDecoration currencyDec;
                    DecimalFormat decimalFormat = (DecimalFormat)format;
                    String icuPattern = decimalFormat.toPattern();
                    decorations.insert(new NumberFormatDecoration(null, icuPattern, decimalFormat.getMultiplier(), decimalFormat.getGroupingSize(), decimalFormat.getGroupingSize()));
                    if (formatStr.contains("$") && null != (currencyDec = AbstractExcelScraper.buildCurrencyDecoration(formatStr))) {
                        decorations.insert(currencyDec);
                    }
                } else if (format instanceof SimpleDateFormat) {
                    if (AbstractExcelScraper.hasExcelSpecialTimeFormatSymbols(formatStr)) {
                        decorations.insert(new DateTimeFormatDecoration(null, "", false, true));
                    } else {
                        SimpleDateFormat dateFormat = (SimpleDateFormat)format;
                        String pattern = dateFormat.toPattern();
                        String strippedPattern = AbstractExcelScraper.stripLiteralsFromPattern(pattern);
                        decorations.insert(new DateTimeFormatDecoration(null, pattern, AbstractExcelScraper.hasICUDateFormatSymbols(strippedPattern), AbstractExcelScraper.hasICUTimeFormatSymbols(strippedPattern)));
                    }
                }
            }
            decorations.insert(new FontStyleDecoration(font.getFontName(), font.getFontHeight() / 20, font.getBoldWeight(), font.isItalic(), font.isStruckout(), AbstractExcelScraper.convertUnderlineStyle(font.getUnderline()), this.getRGBColor(font.getColorPaletteIndex(), new RGBColor(Color.BLACK))));
            decorations.insert(new FillDecoration(this.getRGBColor(xformat.getFillForeground(), new RGBColor(Color.WHITE)), this.getRGBColor(xformat.getFillBackground(), new RGBColor(Color.WHITE))));
            if (0 != xformat.getBorderOptions()) {
                decorations.insert(new BorderDecoration(AbstractExcelScraper.convertBorderStyle(xformat.getBorderLeft()), AbstractExcelScraper.convertBorderStyle(xformat.getBorderRight()), AbstractExcelScraper.convertBorderStyle(xformat.getBorderTop()), AbstractExcelScraper.convertBorderStyle(xformat.getBorderBottom())));
            }
            decorations.insert(new AlignmentDecoration(XLSScraper.convertHAlignment(xformat.getAlignment()), XLSScraper.convertVAlignment(xformat.getVerticalAlignment()), xformat.getIndent()));
            if (null != outDecorations) {
                outDecorations.set((Object)decorations);
            }
            if (null != outFormat) {
                outFormat.set((Object)format);
            }
        }

        private String getFormatStringAt(int formatIdx) throws WAImportException {
            if (formatIdx < 0) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLSX_SCRAPER_ILLEGAL_RECORD_FORMAT, new Object[]{formatIdx}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            if (formatIdx < 164 && XLSScraper.notInRange(formatIdx, this.reservedFormatHigherRange, this.reservedFormatLowerRange)) {
                return BuiltinFormats.getBuiltinFormat((int)formatIdx);
            }
            FormatRecord rec = this.mUserFormatRecords.get(formatIdx);
            if (null == rec) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLSS_SCRAPER_FORMAT_RECORD, new Object[]{formatIdx}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            return rec.getFormatString();
        }

        private FontRecord getFontRecordAt(int fontIdx) throws WAImportException {
            if (fontIdx > 4) {
                --fontIdx;
            }
            if (fontIdx < 0 || fontIdx >= this.mFontRecords.size()) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.ILLEGAL_FONT_INDEX, new Object[]{fontIdx}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            FontRecord rec = this.mFontRecords.get(fontIdx);
            if (null == rec) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLSS_SCRAPER_FONT_RECORD, new Object[]{fontIdx}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            return rec;
        }

        private RGBColor getRGBColor(short index, RGBColor defaultColor) {
            byte[] rgb = this.mPaletteRecord.getColor((int)index);
            if (null == rgb) {
                return defaultColor;
            }
            return new RGBColor(rgb);
        }

        private void checkWorksheetHandler() throws WAImportException {
            if (null == this.mWorksheetHandler) {
                LOGGER.error("The file does not appear to be a valid XLS document - Worksheet handler was null");
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLS).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
        }
    }
}

