/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.excel;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.decoration.CurrencyDecoration;
import com.ibm.neo.dataimport.cdf.decoration.DateTimeFormatDecoration;
import com.ibm.neo.dataimport.cdf.decoration.DecorationMap;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.dataimport.cdf.decoration.NumberFormatDecoration;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeOptions;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeResult;
import com.ibm.neo.dataimport.cdf.scrape.excel.AbstractExcelScraper;
import com.ibm.neo.dataimport.cdf.scrape.excel.ssst.SimpleSharedStringsTable;
import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.io.FastInputStreamReader;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.util.Assertions;
import com.ibm.neo.util.Holder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.NullArgumentException;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSXScraper
extends AbstractExcelScraper {
    private static final Logger LOGGER = LoggerFactory.getLogger(XLSXScraper.class);
    private static final String STRICT_OPENXML_CORE_DOC_REL_TYPE = "http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument";
    private boolean mUse1904windowing = false;

    public XLSXScraper(CDFService cdfService, DocumentType documentType) {
        super(cdfService, documentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrapeResult scrape(String fileName, String mimeType, File file, ScrapeOptions options) throws WAImportException {
        ScrapeResult scrapeResult;
        if (null == fileName) {
            throw new NullArgumentException("fileName");
        }
        if (null == file) {
            throw new NullArgumentException("file");
        }
        if (null == options) {
            throw new NullArgumentException("options");
        }
        OPCPackage pkg = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        try {
            scrapeResult = this.scrapePackage(fileName, mimeType, pkg, options);
        }
        catch (Throwable throwable) {
            try {
                pkg.close();
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.error("IO Error", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.IO_ERROR).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            catch (OpenXML4JException ex) {
                LOGGER.error("The file does not appear to be a valid XLSX document - Invalid OpenXML4J", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
            catch (OpenXML4JRuntimeException ex) {
                this.checkForXMLSS(file);
                LOGGER.error("The file does not appear to be a valid XLSX document - Invalid OpenXML4J", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
            catch (NotOfficeXmlFileException ex) {
                this.checkForXMLSS(file);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
        }
        pkg.close();
        return scrapeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrapeResult scrape(String fileName, String mimeType, InputStream input, ScrapeOptions options) throws WAImportException {
        ScrapeResult scrapeResult;
        if (null == fileName) {
            throw new NullArgumentException("fileName");
        }
        if (null == input) {
            throw new NullArgumentException("input");
        }
        if (null == options) {
            throw new NullArgumentException("options");
        }
        OPCPackage pkg = OPCPackage.open((InputStream)input);
        try {
            scrapeResult = this.scrapePackage(fileName, mimeType, pkg, options);
        }
        catch (Throwable throwable) {
            try {
                pkg.close();
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.error("IO Error", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.IO_ERROR).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            catch (OpenXML4JException ex) {
                LOGGER.error("The file does not appear to be a valid XLSX document - Invalid OpenXML4J", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
            catch (OpenXML4JRuntimeException ex) {
                LOGGER.error("The file does not appear to be a valid XLSX document - Invalid OpenXML4J", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
            catch (NotOfficeXmlFileException ex) {
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
            }
        }
        pkg.close();
        return scrapeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForXMLSS(File file) throws WAImportException {
        try (FastInputStreamReader reader = new FastInputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            String str;
            char[] cbuf = new char[256];
            int len = reader.read(cbuf);
            if (len > 0 && (str = new String(cbuf, 0, len)).contains("<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"")) {
                LOGGER.error("The Excel XMLSS format is not supported");
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.EXCEL_XMLSS_UNSUPPORTED).withConditionCode(EImportMessageCode.EXCEL_XMLSS_UNSUPPORTED).build();
            }
        }
        catch (IOException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScrapeResult scrapePackage(String fileName, String mimeType, OPCPackage pkg, ScrapeOptions options) throws WAImportException {
        DocumentModel doc = new DocumentModel(this.getDocumentType().getTypeName(), this.makeTitle(fileName));
        doc.getProperties().put("filename", fileName);
        if (null != mimeType) {
            doc.getProperties().put("mime-type", mimeType);
        }
        ScrapeResult result = new ScrapeResult(doc);
        boolean success = false;
        try {
            XLSXScraper.checkForStrictOpenXML(pkg);
            XSSFReader xssfReader = new XSSFReader(pkg);
            StylesTable stylesTable = xssfReader.getStylesTable();
            try (SimpleSharedStringsTable stringsTable = new SimpleSharedStringsTable(xssfReader.getSharedStringsData(), this.mCDFService.getXLSXSSTCharsMem(), this.mCDFService.getSheetCacheDir());){
                DocumentSection workbookSection = doc.createSection();
                workbookSection.setName("Workbook");
                workbookSection.setType("excel-workbook");
                try (InputStream workbookData = xssfReader.getWorkbookData();){
                    this.processWorkbook(workbookSection, workbookData);
                }
                XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
                while (iter.hasNext()) {
                    try (InputStream worksheetData = iter.next();){
                        this.processWorksheet(result, options, workbookSection, iter.getSheetName(), stringsTable, stylesTable, worksheetData);
                    }
                }
            }
            success = true;
            ScrapeResult scrapeResult = result;
            return scrapeResult;
        }
        catch (IOException ex) {
            LOGGER.error("IO Error", (Throwable)ex);
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.IO_ERROR).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
        }
        catch (OpenXML4JException ex) {
            LOGGER.error("The file does not appear to be a valid XLSX document - Invalid OpenXML4J", (Throwable)ex);
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
        }
        catch (XMLStreamException ex) {
            LOGGER.error("The file does not appear to be a valid XLSX document - Invalid XML in Shared Strings Table.", (Throwable)ex);
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
        }
        finally {
            if (!success) {
                this.discardSheets(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkbook(DocumentSection workbookSection, InputStream workbookData) throws WAImportException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            boolean workbookPrConsumed = false;
            try (XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(workbookData);){
                while (!workbookPrConsumed && xmlReader.hasNext()) {
                    int eventType = xmlReader.next();
                    switch (eventType) {
                        case 1: {
                            if (!"workbookPr".equals(xmlReader.getLocalName())) break;
                            String date1904Str = xmlReader.getAttributeValue(null, "date1904");
                            this.mUse1904windowing = XLSXScraper.parseBoolean(date1904Str);
                            workbookPrConsumed = true;
                            break;
                        }
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            LOGGER.error("The file does not appear to be a valid XLSX document - Invalid XML", (Throwable)ex);
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorksheet(ScrapeResult result, ScrapeOptions options, DocumentSection workbookSection, String worksheetName, SimpleSharedStringsTable stringsTable, StylesTable stylesTable, InputStream worksheetData) throws WAImportException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            try (XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(worksheetData);){
                AbstractExcelScraper.WorksheetHandler sheetHandler = new AbstractExcelScraper.WorksheetHandler(this, result, options, workbookSection, worksheetName);
                WorksheetContentHandler contentHandler = new WorksheetContentHandler(sheetHandler, stylesTable, stringsTable);
                boolean success = false;
                try {
                    while (xmlReader.hasNext()) {
                        int eventType = xmlReader.next();
                        switch (eventType) {
                            case 1: {
                                contentHandler.startElement(xmlReader);
                                break;
                            }
                            case 2: {
                                contentHandler.endElement(xmlReader);
                                break;
                            }
                            case 4: {
                                contentHandler.characters(xmlReader);
                                break;
                            }
                        }
                    }
                    success = true;
                    sheetHandler.finish(!success);
                }
                catch (Throwable throwable) {
                    sheetHandler.finish(!success);
                    throw throwable;
                }
            }
        }
        catch (XMLStreamException ex) {
            LOGGER.error("The file does not appear to be a valid XLSX document - Invalid XML", (Throwable)ex);
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
        }
    }

    private static int cellCoord2ColumnIndex(String cellCoordinate) {
        if (null == cellCoordinate) {
            throw new NullArgumentException("cellCoordinate");
        }
        int firstDigit = -1;
        for (int i = 0; i < cellCoordinate.length(); ++i) {
            if (!Character.isDigit(cellCoordinate.charAt(i))) continue;
            firstDigit = i;
            break;
        }
        Assertions.assertNotEqual((Object)-1, (Object)firstDigit, (String)"firstDigit != -1");
        String columnName = cellCoordinate.substring(0, firstDigit);
        return XLSXScraper.columnName2Index(columnName);
    }

    private static int columnName2Index(String columnName) {
        if (null == columnName) {
            throw new NullArgumentException("columnName");
        }
        int columnIndex = 0;
        for (int i = 0; i < columnName.length(); ++i) {
            char c = Character.toUpperCase(columnName.charAt(i));
            columnIndex *= 26;
            columnIndex += c - 65 + 1;
        }
        return columnIndex - 1;
    }

    private static ECellType getCellType(String typeName) {
        if ("n".equals(typeName)) {
            return ECellType.NUMBER;
        }
        if ("s".equals(typeName)) {
            return ECellType.SHARED_STRING;
        }
        if ("inlineStr".equals(typeName)) {
            return ECellType.INLINE_STRING;
        }
        if ("str".equals(typeName)) {
            return ECellType.FORMULA_STRING;
        }
        if ("b".equals(typeName)) {
            return ECellType.BOOLEAN;
        }
        if ("e".equals(typeName)) {
            return ECellType.ERROR;
        }
        return ECellType.NUMBER;
    }

    private static void checkForStrictOpenXML(OPCPackage pkg) throws WAImportException {
        PackageRelationshipCollection coreDocRelationships = pkg.getRelationshipsByType(STRICT_OPENXML_CORE_DOC_REL_TYPE);
        if (coreDocRelationships.size() > 0) {
            LOGGER.error("Strict OpenXML format documents are not supported");
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.EXCEL_STRICT_OPENXML_UNSUPPORTED).withConditionCode(EImportMessageCode.EXCEL_STRICT_OPENXML_UNSUPPORTED).build();
        }
    }

    static {
        ZipSecureFile.setMinInflateRatio((double)0.0075);
    }

    private final class WorksheetContentHandler {
        private static final String DEFAULT_STYLE_REF = "__default__";
        private final AbstractExcelScraper.WorksheetHandler mWorksheetHandler;
        private final StylesTable mStylesTable;
        private final Map<String, XSSFCellStyle> mStylesCache = new HashMap<String, XSSFCellStyle>();
        private final SimpleSharedStringsTable mStringsTable;
        private final StringBuilder mValueBuffer = new StringBuilder();
        private ArrayDeque<EWorksheetParseState> mParseState = new ArrayDeque();
        private int mCurrRowIndex = -1;
        private int mCurrColumnIndex = -1;
        private ECellType mCurrCellType = ECellType.NUMBER;
        private XSSFCellStyle mCurrCellStyle = null;

        public WorksheetContentHandler(AbstractExcelScraper.WorksheetHandler worksheetHandler, StylesTable stylesTable, SimpleSharedStringsTable stringsTable) {
            this.mWorksheetHandler = worksheetHandler;
            this.mStylesTable = stylesTable;
            this.mStylesCache.put(DEFAULT_STYLE_REF, new XSSFCellStyle(stylesTable));
            this.mStringsTable = stringsTable;
            this.mParseState.addLast(EWorksheetParseState.ROOT);
        }

        void startElement(XMLStreamReader xmlReader) throws WAImportException {
            String name = xmlReader.getLocalName();
            switch (this.mParseState.peekLast()) {
                case ROOT: {
                    if (!"sheetData".equals(name)) break;
                    this.mParseState.addLast(EWorksheetParseState.SHEET_DATA);
                    break;
                }
                case SHEET_DATA: {
                    if (!"row".equals(name)) break;
                    int rowIndex = 0;
                    try {
                        String value = xmlReader.getAttributeValue(null, "r");
                        rowIndex = value != null ? Integer.parseInt(xmlReader.getAttributeValue(null, "r")) - 1 : this.mWorksheetHandler.getmCurrentRowNumber() + 1;
                    }
                    catch (Exception ex) {
                        LOGGER.error("The file does not appear to be a valid XLSX document - Failed to parse row index", (Throwable)ex);
                        throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
                    }
                    this.mParseState.addLast(EWorksheetParseState.ROW);
                    this.mCurrColumnIndex = -1;
                    this.handleRow(rowIndex);
                    break;
                }
                case ROW: {
                    if (!"c".equals(name)) break;
                    String cellCoordStr = xmlReader.getAttributeValue(null, "r");
                    String cellTypeStr = xmlReader.getAttributeValue(null, "t");
                    String cellStyleStr = xmlReader.getAttributeValue(null, "s");
                    this.mParseState.addLast(EWorksheetParseState.CELL);
                    this.mCurrColumnIndex = null != cellCoordStr && !cellCoordStr.isEmpty() ? XLSXScraper.cellCoord2ColumnIndex(cellCoordStr) : ++this.mCurrColumnIndex;
                    this.mCurrCellType = XLSXScraper.getCellType(cellTypeStr);
                    this.mCurrCellStyle = this.getCellStyle(cellStyleStr);
                    break;
                }
                case CELL: {
                    if ("v".equals(name)) {
                        this.mParseState.addLast(EWorksheetParseState.VALUE);
                        this.mValueBuffer.setLength(0);
                        break;
                    }
                    if (!"is".equals(name)) break;
                    this.mParseState.addLast(EWorksheetParseState.INLINE_STRING);
                    break;
                }
                case INLINE_STRING: {
                    if (!"t".equals(name)) break;
                    this.mParseState.addLast(EWorksheetParseState.TEXT);
                    this.mValueBuffer.setLength(0);
                    break;
                }
                case TEXT: 
                case VALUE: {
                    break;
                }
                default: {
                    LOGGER.error("Unexpected parser state: " + this.mParseState);
                    throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_SCRAPER_BAD_STATE_XLSX, new Object[]{this.mParseState}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
                }
            }
        }

        void endElement(XMLStreamReader xmlReader) throws WAImportException {
            String name = xmlReader.getLocalName();
            switch (this.mParseState.peekLast()) {
                case CELL: {
                    if (!"c".equals(name)) break;
                    this.handleCell();
                    this.mValueBuffer.setLength(0);
                    this.mParseState.removeLast();
                    break;
                }
                case INLINE_STRING: {
                    if (!"is".equals(name)) break;
                    this.mParseState.removeLast();
                    break;
                }
                case TEXT: {
                    if (!"t".equals(name)) break;
                    this.mParseState.removeLast();
                    break;
                }
                case VALUE: {
                    if (!"v".equals(name)) break;
                    this.mParseState.removeLast();
                    break;
                }
                case ROW: {
                    if (!"row".equals(name)) break;
                    this.mWorksheetHandler.handleEndRow(this.mCurrRowIndex);
                    this.mParseState.removeLast();
                    break;
                }
                case SHEET_DATA: {
                    if (!"sheetData".equals(name)) break;
                    this.mParseState.removeLast();
                    break;
                }
                case ROOT: {
                    break;
                }
                default: {
                    LOGGER.error("Unexpected parser state: " + this.mParseState);
                    throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_SCRAPER_BAD_STATE_XLSX, new Object[]{this.mParseState}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
                }
            }
        }

        void characters(XMLStreamReader xmlReader) throws WAImportException {
            switch (this.mParseState.peekLast()) {
                case TEXT: 
                case VALUE: {
                    this.mValueBuffer.append(xmlReader.getTextCharacters(), xmlReader.getTextStart(), xmlReader.getTextLength());
                    break;
                }
            }
        }

        private void handleRow(int rowIndex) throws WAImportException {
            for (int i = this.mCurrRowIndex + 1; i < rowIndex; ++i) {
                this.mWorksheetHandler.handleStartRow(i);
                this.mWorksheetHandler.handleEndRow(i);
            }
            this.mCurrRowIndex = rowIndex;
            this.mWorksheetHandler.handleStartRow(this.mCurrRowIndex);
        }

        private void handleCell() throws WAImportException {
            switch (this.mCurrCellType) {
                case NUMBER: {
                    this.handleNumberCell();
                    break;
                }
                case SHARED_STRING: {
                    this.handleSharedStringCell();
                    break;
                }
                case INLINE_STRING: {
                    this.handleInlineStringCell();
                    break;
                }
                case FORMULA_STRING: {
                    this.handleFormulaStringCell();
                    break;
                }
                case BOOLEAN: {
                    this.handleBooleanCell();
                    break;
                }
                case ERROR: {
                    this.handleErrorCell();
                    break;
                }
                default: {
                    LOGGER.error("Unexpected cell type: " + (Object)((Object)this.mCurrCellType));
                    throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_XLSX_SCRAPER_ILLEGAL_CELL_TYPE, new Object[]{this.mCurrCellType}).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
                }
            }
        }

        private void handleBooleanCell() throws WAImportException {
            Holder decorationsHolder = new Holder();
            this.processFormatAndDecorations(false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
            if (this.mValueBuffer.length() == 0) {
                this.mWorksheetHandler.handleBlankCell(this.mCurrRowIndex, this.mCurrColumnIndex, (DecorationMap)decorationsHolder.get());
                return;
            }
            boolean booleanValue = AbstractExcelScraper.parseBoolean(this.mValueBuffer.toString());
            this.mWorksheetHandler.handleBooleanCell(this.mCurrRowIndex, this.mCurrColumnIndex, booleanValue, (DecorationMap)decorationsHolder.get());
        }

        private void handleErrorCell() throws WAImportException {
            Holder decorationsHolder = new Holder();
            this.processFormatAndDecorations(false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
            this.mWorksheetHandler.handleBlankCell(this.mCurrRowIndex, this.mCurrColumnIndex, (DecorationMap)decorationsHolder.get());
        }

        private void handleNumberCell() throws WAImportException {
            Holder decorationsHolder = new Holder();
            if (this.mValueBuffer.length() == 0) {
                this.processFormatAndDecorations(false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
                this.mWorksheetHandler.handleBlankCell(this.mCurrRowIndex, this.mCurrColumnIndex, (DecorationMap)decorationsHolder.get());
                return;
            }
            Holder formatHolder = new Holder();
            double dblValue = Double.parseDouble(this.mValueBuffer.toString());
            this.processFormatAndDecorations(true, dblValue, (Holder<DecorationMap>)decorationsHolder, (Holder<Format>)formatHolder);
            if (((DecorationMap)decorationsHolder.get()).containsKey(EDecorationType.DATETIME_FORMAT)) {
                DateTimeFormatDecoration dtf = (DateTimeFormatDecoration)((DecorationMap)decorationsHolder.get()).get(EDecorationType.DATETIME_FORMAT);
                Date dateValue = XLSXScraper.this.parseSerialDate(dblValue, dtf.hasDateFields(), dtf.hasTimeFields(), XLSXScraper.this.mUse1904windowing);
                if (null != dateValue) {
                    this.mWorksheetHandler.handleDateCell(this.mCurrRowIndex, this.mCurrColumnIndex, dateValue, (DecorationMap)decorationsHolder.get());
                }
            } else if (((DecorationMap)decorationsHolder.get()).containsKey(EDecorationType.NUMBER_FORMAT)) {
                this.mWorksheetHandler.handleNumericCell(this.mCurrRowIndex, this.mCurrColumnIndex, dblValue, (DecorationMap)decorationsHolder.get());
            } else if (null != formatHolder.get()) {
                this.mWorksheetHandler.handleStringCell(this.mCurrRowIndex, this.mCurrColumnIndex, ((Format)formatHolder.get()).format(dblValue), (DecorationMap)decorationsHolder.get());
            } else {
                this.mWorksheetHandler.handleNumericCell(this.mCurrRowIndex, this.mCurrColumnIndex, dblValue, (DecorationMap)decorationsHolder.get());
            }
        }

        private void handleSharedStringCell() throws WAImportException {
            Holder decorationsHolder = new Holder();
            this.processFormatAndDecorations(false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
            if (this.mValueBuffer.length() == 0) {
                this.mWorksheetHandler.handleBlankCell(this.mCurrRowIndex, this.mCurrColumnIndex, (DecorationMap)decorationsHolder.get());
                return;
            }
            int stringIdx = Integer.parseInt(this.mValueBuffer.toString());
            String strValue = null;
            try {
                strValue = this.mStringsTable.get(stringIdx);
            }
            catch (IOException ex) {
                LOGGER.error("Unable to read shared string from table.", (Throwable)ex);
                throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.IO_ERROR).withCause((Throwable)ex).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
            this.mWorksheetHandler.handleStringCell(this.mCurrRowIndex, this.mCurrColumnIndex, strValue, (DecorationMap)decorationsHolder.get());
        }

        private void handleInlineStringCell() throws WAImportException {
            Holder decorationsHolder = new Holder();
            this.processFormatAndDecorations(false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
            if (this.mValueBuffer.length() == 0) {
                this.mWorksheetHandler.handleBlankCell(this.mCurrRowIndex, this.mCurrColumnIndex, (DecorationMap)decorationsHolder.get());
                return;
            }
            XSSFRichTextString richText = new XSSFRichTextString(this.mValueBuffer.toString());
            String strValue = richText.getString();
            this.mWorksheetHandler.handleStringCell(this.mCurrRowIndex, this.mCurrColumnIndex, strValue, (DecorationMap)decorationsHolder.get());
        }

        private void handleFormulaStringCell() throws WAImportException {
            XSSFRichTextString richText = new XSSFRichTextString(this.mValueBuffer.toString());
            String strValue = richText.getString();
            Holder decorationsHolder = new Holder();
            this.processFormatAndDecorations(false, 0.0, (Holder<DecorationMap>)decorationsHolder, null);
            this.mWorksheetHandler.handleStringCell(this.mCurrRowIndex, this.mCurrColumnIndex, strValue, (DecorationMap)decorationsHolder.get());
        }

        private void processFormatAndDecorations(boolean hasNumber, double dblValue, Holder<DecorationMap> outDecorations, Holder<Format> outFormat) throws WAImportException {
            DecorationMap decorations = new DecorationMap();
            Format format = null;
            if (hasNumber) {
                String formatStr;
                short formatIdx = this.mCurrCellStyle.getDataFormat();
                try {
                    formatStr = this.mCurrCellStyle.getDataFormatString();
                }
                catch (NullPointerException e) {
                    LOGGER.error("The file does not appear to be a valid XLSX document", (Throwable)e);
                    if (formatIdx == 0) {
                        formatStr = "General";
                    }
                    throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INVALID_FILE_FORMAT_XLSX).withCause((Throwable)e).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).build();
                }
                if (null != formatStr) {
                    format = XLSXScraper.this.getFormat(dblValue, formatIdx, formatStr);
                    if (format instanceof DecimalFormat) {
                        CurrencyDecoration currencyDec;
                        DecimalFormat decimalFormat = (DecimalFormat)format;
                        String icuPattern = decimalFormat.toPattern();
                        decorations.insert(new NumberFormatDecoration(null, icuPattern, decimalFormat.getMultiplier(), decimalFormat.getGroupingSize(), decimalFormat.getGroupingSize()));
                        if (formatStr.contains("$") && null != (currencyDec = AbstractExcelScraper.buildCurrencyDecoration(formatStr))) {
                            decorations.insert(currencyDec);
                        }
                    } else if (format instanceof SimpleDateFormat) {
                        if (AbstractExcelScraper.hasExcelSpecialTimeFormatSymbols(formatStr)) {
                            decorations.insert(new DateTimeFormatDecoration(null, "", false, true));
                        } else {
                            SimpleDateFormat dateFormat = (SimpleDateFormat)format;
                            String pattern = dateFormat.toPattern();
                            String strippedPattern = AbstractExcelScraper.stripLiteralsFromPattern(pattern);
                            decorations.insert(new DateTimeFormatDecoration(null, pattern, AbstractExcelScraper.hasICUDateFormatSymbols(strippedPattern), AbstractExcelScraper.hasICUTimeFormatSymbols(strippedPattern)));
                        }
                    }
                }
            }
            if (null != outDecorations) {
                outDecorations.set((Object)decorations);
            }
            if (null != outFormat) {
                outFormat.set(format);
            }
        }

        private XSSFCellStyle getCellStyle(String styleRef) {
            XSSFCellStyle style;
            if (null == styleRef || styleRef.isEmpty()) {
                styleRef = DEFAULT_STYLE_REF;
            }
            if (null == (style = this.mStylesCache.get(styleRef))) {
                int styleIndex = Integer.parseInt(styleRef);
                style = this.mStylesTable.getStyleAt(styleIndex);
                if (null == style) {
                    style = this.mStylesCache.get(DEFAULT_STYLE_REF);
                }
                this.mStylesCache.put(styleRef, style);
            }
            return style;
        }
    }

    public static enum EWorksheetParseState {
        ROOT,
        SHEET_DATA,
        ROW,
        CELL,
        INLINE_STRING,
        VALUE,
        TEXT;

    }

    private static enum ECellType {
        NUMBER,
        DATE,
        BOOLEAN,
        SHARED_STRING,
        INLINE_STRING,
        FORMULA_STRING,
        ERROR;

    }
}

