/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.excel.ssst;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SharedStringsReader
implements AutoCloseable {
    private InputStream inputStream;
    private XMLStreamReader reader;
    private boolean moreStrings = true;
    private String nextString;
    private static final String INVALID_ELEMENT_STRING = "Invalid element: ";
    private static final String UNEXPECTED_EOF_STRING = "Unexpected End of File.";
    private static final String NO_MORE_STRINGS_STRING = "No more strings in SharedStringsTable.";

    public SharedStringsReader(InputStream in) throws XMLStreamException {
        this.inputStream = in;
        if (in == null) {
            this.moreStrings = false;
            return;
        }
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.reader = inputFactory.createXMLStreamReader(in);
        this.readDocumentRoot();
        this.readNextString();
    }

    public String next() throws XMLStreamException {
        if (!this.moreStrings) {
            throw new NoSuchElementException(NO_MORE_STRINGS_STRING);
        }
        String str = this.nextString;
        this.readNextString();
        return str;
    }

    public boolean hasNext() {
        return this.moreStrings;
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    private void skipElement() throws XMLStreamException {
        int depth = 1;
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
            if (depth != 0) continue;
            return;
        }
        throw new XMLStreamException(UNEXPECTED_EOF_STRING);
    }

    private void readDocumentRoot() throws XMLStreamException {
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if ("sst".equals(name)) {
                        return;
                    }
                    throw new XMLStreamException(INVALID_ELEMENT_STRING + name);
                }
            }
        }
        throw new XMLStreamException(UNEXPECTED_EOF_STRING);
    }

    private void readNextString() throws XMLStreamException {
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if ("si".equals(name)) {
                        this.nextString = this.readString();
                        return;
                    }
                    if ("extLst".equals(name)) {
                        this.skipElement();
                        break;
                    }
                    throw new XMLStreamException(INVALID_ELEMENT_STRING + name);
                }
                case 2: {
                    this.moreStrings = false;
                    return;
                }
            }
        }
        throw new XMLStreamException(UNEXPECTED_EOF_STRING);
    }

    private String readString() throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if ("t".equals(name)) {
                        sb.append(this.reader.getElementText());
                        break;
                    }
                    if ("r".equals(name)) {
                        sb.append(this.readRichString());
                        break;
                    }
                    if ("rPh".equals(name) || "phoneticPr".equals(name)) {
                        this.skipElement();
                        break;
                    }
                    throw new XMLStreamException(INVALID_ELEMENT_STRING + name);
                }
                case 2: {
                    return sb.toString();
                }
            }
        }
        throw new XMLStreamException(UNEXPECTED_EOF_STRING);
    }

    private String readRichString() throws XMLStreamException {
        String str = null;
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if ("rPr".equals(name)) {
                        this.skipElement();
                        break;
                    }
                    if ("t".equals(name)) {
                        str = this.reader.getElementText();
                        break;
                    }
                    throw new XMLStreamException(INVALID_ELEMENT_STRING + name);
                }
                case 2: {
                    return str;
                }
            }
        }
        throw new XMLStreamException(UNEXPECTED_EOF_STRING);
    }
}

