/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.excel.ssst;

import com.ibm.neo.dataimport.cdf.scrape.excel.ssst.SharedStringsReader;
import com.ibm.neo.dataimport.cdf.scrape.excel.ssst.StringFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class SimpleSharedStringsTable
implements AutoCloseable {
    private List<String> sl = new ArrayList<String>();
    private StringFile sf;

    public SimpleSharedStringsTable(InputStream in, int maxCharsInMem, File tempDir) throws XMLStreamException, IOException {
        try (SharedStringsReader ssr = new SharedStringsReader(in);){
            int numChars = 0;
            while (ssr.hasNext()) {
                String str = ssr.next();
                this.sl.add(str);
                if ((numChars += str.length()) <= maxCharsInMem && this.sl.size() <= 0x7FFFFFF5) continue;
                this.sf = new StringFile("SharedStrings-", tempDir);
                for (String s : this.sl) {
                    this.sf.add(s);
                }
                this.sl = null;
                while (ssr.hasNext()) {
                    this.sf.add(ssr.next());
                }
                break;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.sl = null;
        if (this.sf != null) {
            this.sf.close();
            this.sf = null;
        }
    }

    public String get(long index) throws IOException {
        if (this.sl != null) {
            return this.sl.get((int)Math.min(index, Integer.MAX_VALUE));
        }
        if (this.sf != null) {
            return this.sf.get(index);
        }
        throw new IOException("Cannot read from strings table.");
    }

    public long size() {
        if (this.sl != null) {
            return this.sl.size();
        }
        if (this.sf != null) {
            return this.sf.size();
        }
        return 0L;
    }
}

