/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.excel.ssst;

import com.ibm.neo.dataimport.cdf.scrape.excel.ssst.BiggerList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFile
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(StringFile.class);
    private File file;
    private BufferedWriter writer;
    private RandomAccessFile reader;
    private BiggerList<Long> offsets;
    private boolean modified = false;
    private boolean closed = false;
    private static final String EXCEPTION_ALREADY_CLEANED_UP = "StringFile already cleaned up.";
    private static final String EXCEPTION_INVALID_INDEX = "Invalid index.";

    public StringFile(String prefix) throws IOException {
        this(prefix, null);
    }

    public StringFile(String prefix, File tempDir) throws IOException {
        this.file = tempDir == null ? File.createTempFile(prefix, ".temp") : File.createTempFile(prefix, ".temp", tempDir);
        this.file.deleteOnExit();
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_16));
        this.reader = new RandomAccessFile(this.file, "r");
        this.offsets = new BiggerList();
        this.offsets.add(2L);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.file != null) {
            if (!this.file.delete()) {
                LOG.error("Failed to cleanup temporary Strings file: {}", (Object)this.file.getAbsolutePath());
            }
            this.file = null;
        }
        this.offsets = null;
        this.closed = true;
    }

    public long size() {
        if (this.closed) {
            return 0L;
        }
        return this.offsets.size() - 1L;
    }

    public void add(String str) throws IOException {
        if (this.closed) {
            throw new IOException(EXCEPTION_ALREADY_CLEANED_UP);
        }
        this.writer.write(str);
        this.offsets.add(this.offsets.get(this.size()) + (long)(2 * str.length()));
        this.modified = true;
    }

    public String get(long index) throws IOException {
        if (this.closed) {
            throw new IOException(EXCEPTION_ALREADY_CLEANED_UP);
        }
        if (index < 0L || index >= this.size()) {
            throw new IOException(EXCEPTION_INVALID_INDEX);
        }
        if (this.modified) {
            this.writer.flush();
            this.modified = false;
        }
        this.reader.seek(this.offsets.get(index));
        int len = (int)(this.offsets.get(index + 1L) - this.offsets.get(index));
        byte[] data = new byte[len];
        this.reader.readFully(data);
        return new String(data, StandardCharsets.UTF_16);
    }
}

