/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CountryAnalyzer {
    private static final Map<String, List<Locale>> ISO2_COUNTRY_2_LOCALES = new HashMap<String, List<Locale>>();
    private static final Map<String, List<Locale>> ISO3_COUNTRY_2_LOCALES = new HashMap<String, List<Locale>>();
    private static final Map<String, List<CountryDisplayLocalePair>> COUNTRY_NAME_2_COUNTRY_DISPLAY_LOCALE = new HashMap<String, List<CountryDisplayLocalePair>>();
    private static final Pattern WORD_PATTERN = Pattern.compile("([^\\s\\p{Punct}]+)");

    public static Set<String> getISO2CountryCodes() {
        return Collections.unmodifiableSet(ISO2_COUNTRY_2_LOCALES.keySet());
    }

    public static Set<String> getISO3CountryCodes() {
        return Collections.unmodifiableSet(ISO3_COUNTRY_2_LOCALES.keySet());
    }

    public static Report analyze(String text) {
        Report report = new Report();
        CountryAnalyzer.analyzeImpl(new String[]{text}, report);
        return report;
    }

    public static Report analyze(String[] texts) {
        Report report = new Report();
        CountryAnalyzer.analyzeImpl(texts, report);
        return report;
    }

    private static void analyzeImpl(String[] texts, Report report) {
        for (String text : texts) {
            Matcher wordMatcher = WORD_PATTERN.matcher(text);
            while (wordMatcher.find()) {
                List<CountryDisplayLocalePair> pairs;
                List<Locale> locales;
                String word = wordMatcher.group();
                if (word.length() == 2) {
                    locales = CountryAnalyzer.getLocalesForISO2Country(word);
                    if (!locales.isEmpty()) {
                        report.mISO2Countries.add(word);
                        report.mReferencedCountries.addAll(locales);
                        continue;
                    }
                } else if (word.length() == 3 && !(locales = CountryAnalyzer.getLocalesForISO3Country(word)).isEmpty()) {
                    report.mISO3Countries.add(word);
                    report.mReferencedCountries.addAll(locales);
                    continue;
                }
                if (null == (pairs = COUNTRY_NAME_2_COUNTRY_DISPLAY_LOCALE.get(word.toLowerCase()))) continue;
                report.mCountryNames.add(word);
                for (CountryDisplayLocalePair pair : pairs) {
                    report.mReferencedCountries.add(pair.getCountryLocale());
                    report.mDisplayLanguages.add(pair.getDisplayLocale());
                }
            }
        }
    }

    private static List<Locale> getLocalesForISO2Country(String iso2CountryCode) {
        List<Locale> locales = ISO2_COUNTRY_2_LOCALES.get(iso2CountryCode);
        if (null == locales) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(locales);
    }

    private static List<Locale> getLocalesForISO3Country(String iso3CountryCode) {
        List<Locale> locales = ISO3_COUNTRY_2_LOCALES.get(iso3CountryCode);
        if (null == locales) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(locales);
    }

    private static void registerISO2Country(String iso2CountryCode, Locale locale) {
        if (null == iso2CountryCode || iso2CountryCode.length() == 0) {
            return;
        }
        List<Locale> locales = ISO2_COUNTRY_2_LOCALES.get(iso2CountryCode);
        if (null == locales) {
            locales = new ArrayList<Locale>();
            ISO2_COUNTRY_2_LOCALES.put(iso2CountryCode, locales);
        }
        locales.add(locale);
    }

    private static void registerISO3Country(String iso3CountryCode, Locale locale) {
        if (null == iso3CountryCode || iso3CountryCode.length() == 0) {
            return;
        }
        List<Locale> locales = ISO3_COUNTRY_2_LOCALES.get(iso3CountryCode);
        if (null == locales) {
            locales = new ArrayList<Locale>();
            ISO3_COUNTRY_2_LOCALES.put(iso3CountryCode, locales);
        }
        locales.add(locale);
    }

    static {
        for (Locale loc : Locale.getAvailableLocales()) {
            CountryAnalyzer.registerISO2Country(loc.getCountry(), loc);
            CountryAnalyzer.registerISO3Country(loc.getISO3Country(), loc);
        }
        for (String countryCode : ISO2_COUNTRY_2_LOCALES.keySet()) {
            Locale countryLocale = new Locale("", countryCode);
            for (String lang : Locale.getISOLanguages()) {
                Locale displayLocale = new Locale(lang);
                String localizedName = countryLocale.getDisplayCountry(displayLocale).toLowerCase(displayLocale);
                List<CountryDisplayLocalePair> pairs = COUNTRY_NAME_2_COUNTRY_DISPLAY_LOCALE.get(localizedName);
                if (null == pairs) {
                    pairs = new ArrayList<CountryDisplayLocalePair>();
                    COUNTRY_NAME_2_COUNTRY_DISPLAY_LOCALE.put(localizedName, pairs);
                }
                pairs.add(new CountryDisplayLocalePair(countryLocale, displayLocale));
            }
        }
    }

    private static final class CountryDisplayLocalePair {
        private final Locale mCountryLocale;
        private final Locale mDisplayLocale;

        CountryDisplayLocalePair(Locale countryLocale, Locale displayLocale) {
            this.mCountryLocale = countryLocale;
            this.mDisplayLocale = displayLocale;
        }

        Locale getCountryLocale() {
            return this.mCountryLocale;
        }

        Locale getDisplayLocale() {
            return this.mDisplayLocale;
        }

        public String toString() {
            return this.mCountryLocale.toString() + "(" + this.mDisplayLocale.toString() + ")";
        }
    }

    public static final class Report {
        private final Set<String> mISO2Countries = new HashSet<String>(2);
        private final Set<String> mISO3Countries = new HashSet<String>(2);
        private final Set<String> mCountryNames = new HashSet<String>(2);
        private final Set<Locale> mReferencedCountries = new HashSet<Locale>(2);
        private final Set<Locale> mDisplayLanguages = new HashSet<Locale>(2);

        public Set<String> getISO2Countries() {
            return this.mISO2Countries;
        }

        public Set<String> getISO3Countries() {
            return this.mISO3Countries;
        }

        public Set<String> getCountryNames() {
            return this.mCountryNames;
        }

        public Set<Locale> getReferencedCountries() {
            return this.mReferencedCountries;
        }

        public Set<Locale> getDisplayLanguages() {
            return this.mDisplayLanguages;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ISO2 Countries: ").append(this.mISO2Countries).append('\n');
            sb.append("ISO3 Countries: ").append(this.mISO3Countries).append('\n');
            sb.append("Country Names: ").append(this.mCountryNames).append('\n');
            sb.append("Referenced Countries: ").append(this.mReferencedCountries).append('\n');
            sb.append("Display Languages: ").append(this.mDisplayLanguages);
            return sb.toString();
        }
    }
}

