/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.scrape.text;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CurrencyAnalyzer {
    private static final Set<Currency> ALL_CURRENCIES = new HashSet<Currency>();
    private static final Map<Locale, String> CURRENCY_FORMAT_PATTERNS = new HashMap<Locale, String>();
    private static final Map<String, CurrencySymbolInfo> CURRENCY_SYMBOL_2_INFO = new HashMap<String, CurrencySymbolInfo>();

    public static Report analyze(String text) {
        Report report = new Report();
        for (Currency currency : ALL_CURRENCIES) {
            if (!text.contains(currency.getCurrencyCode())) continue;
            report.mISOCurrencies.add(currency.getCurrencyCode());
            report.mPotentialCurrencies.add(currency);
        }
        for (Map.Entry entry : CURRENCY_SYMBOL_2_INFO.entrySet()) {
            String curSymbol = (String)entry.getKey();
            CurrencySymbolInfo info = (CurrencySymbolInfo)entry.getValue();
            int pos = text.indexOf(curSymbol);
            if (pos == -1) continue;
            boolean isPrefix = pos < text.length() / 2;
            report.mCurrencySymbols.add(curSymbol);
            if (report.mISOCurrencies.isEmpty()) {
                for (Currency cur : info.mCurrencies) {
                    report.mPotentialCurrencies.add(cur);
                }
            }
            for (Locale loc : info.mDisplayLocales) {
                String pattern = CURRENCY_FORMAT_PATTERNS.get(loc);
                if (null == pattern || isPrefix != pattern.indexOf(164) < pattern.length() / 2) continue;
                report.mDisplayLocales.add(loc);
            }
        }
        return report;
    }

    static {
        Locale[] allLocales = Currency.getAvailableLocales();
        for (Locale loc : allLocales) {
            Currency cur = Currency.getInstance((Locale)loc);
            if (null == cur) continue;
            ALL_CURRENCIES.add(cur);
            NumberFormat curFormat = NumberFormat.getCurrencyInstance((Locale)loc);
            if (!(curFormat instanceof DecimalFormat)) continue;
            CURRENCY_FORMAT_PATTERNS.put(loc, ((DecimalFormat)curFormat).toPattern());
        }
        for (Currency cur : ALL_CURRENCIES) {
            for (Locale loc : allLocales) {
                String curSymbol = cur.getSymbol(loc);
                if (null == curSymbol || curSymbol.isEmpty()) continue;
                CurrencySymbolInfo info = CURRENCY_SYMBOL_2_INFO.get(curSymbol);
                if (null == info) {
                    info = new CurrencySymbolInfo();
                    CURRENCY_SYMBOL_2_INFO.put(curSymbol, info);
                }
                info.mCurrencies.add(cur);
                info.mDisplayLocales.add(loc);
            }
        }
    }

    private static final class CurrencySymbolInfo {
        private final Set<Currency> mCurrencies = new HashSet<Currency>(2);
        private final Set<Locale> mDisplayLocales = new HashSet<Locale>(2);

        private CurrencySymbolInfo() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Currencies: ").append(this.mCurrencies).append('\n');
            sb.append("Display Locales: ").append(this.mDisplayLocales);
            return sb.toString();
        }
    }

    public static final class Report {
        private final Set<String> mISOCurrencies = new HashSet<String>(2);
        private final Set<String> mCurrencySymbols = new HashSet<String>(2);
        private final Set<Currency> mPotentialCurrencies = new HashSet<Currency>(2);
        private final Set<Locale> mDisplayLocales = new HashSet<Locale>(2);

        public Set<String> getISOCurrencies() {
            return this.mISOCurrencies;
        }

        public Set<String> getCurrencySymbols() {
            return this.mCurrencySymbols;
        }

        public Set<Currency> getPotentialCurrencies() {
            return this.mPotentialCurrencies;
        }

        public Set<Locale> getDisplayLocales() {
            return this.mDisplayLocales;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

