/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet;

import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.sheet.ICDFPartitionedSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedSheet;
import com.ibm.neo.dataimport.cdf.sheet.impl.PartitionedSheet;
import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class CDFSheetFactory {
    private static final String sMachineId = CDFSheetFactory.getMachineId();
    private static final AtomicLong sCounter = new AtomicLong();

    private static synchronized String generateSheetId() {
        return new StringBuffer(UUID.randomUUID().toString()).append('-').append(sMachineId).append('-').append(Long.toHexString(sCounter.getAndIncrement())).toString();
    }

    private static String getMachineId() {
        HashCodeBuilder macHashBuilder = new HashCodeBuilder();
        try {
            Enumeration<NetworkInterface> interfacesEnum = NetworkInterface.getNetworkInterfaces();
            if (null != interfacesEnum) {
                for (NetworkInterface iface : Collections.list(interfacesEnum)) {
                    byte[] mac = iface.getHardwareAddress();
                    if (null == mac) continue;
                    macHashBuilder.append(mac);
                }
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        return Integer.toHexString(macHashBuilder.toHashCode());
    }

    public static ICDFSheet createSheet(CDFService cdfService) throws IOException {
        return CDFSheetFactory.createSheet(cdfService, CDFSheetFactory.generateSheetId());
    }

    public static ICDFSheet createSheet(CDFService cdfService, String sheetId) throws IOException {
        return new PagedSheet(sheetId, CDFSheetFactory.makeSheetDataDir(cdfService, sheetId));
    }

    public static ICDFSheet createSheet(String sheetId, File dataDir) throws IOException {
        return new PagedSheet(sheetId, CDFSheetFactory.makeSheetDataDir(dataDir, sheetId));
    }

    public static ICDFPartitionedSheet createPartitionedSheet(CDFService cdfService, int numPartitions, int blockSize) throws IOException {
        return CDFSheetFactory.createPartitionedSheet(cdfService, CDFSheetFactory.generateSheetId(), numPartitions, blockSize);
    }

    public static ICDFPartitionedSheet createPartitionedSheet(CDFService cdfService, String sheetId, int numPartitions, int blockSize) throws IOException {
        return new PartitionedSheet(sheetId, CDFSheetFactory.makeSheetDataDir(cdfService, sheetId), numPartitions, blockSize);
    }

    public static ICDFPartitionedSheet createPartitionedSheet(CDFService cdfService, String sheetId) throws IOException {
        return new PartitionedSheet(sheetId, CDFSheetFactory.makeSheetDataDir(cdfService, sheetId));
    }

    public static ICDFPartitionedSheet createPartitionedSheet(String sheetId, File sheetCacheDir, int numPartitions, int blockSize) throws IOException {
        return new PartitionedSheet(sheetId, CDFSheetFactory.makeSheetDataDir(sheetCacheDir, sheetId), numPartitions, blockSize);
    }

    public static ICDFPartitionedSheet createPartitionedSheet(String sheetId, File sheetCacheDir) throws IOException {
        return new PartitionedSheet(sheetId, CDFSheetFactory.makeSheetDataDir(sheetCacheDir, sheetId));
    }

    private static File makeSheetDataDir(CDFService cdfService, String sheetId) {
        return CDFSheetFactory.makeSheetDataDir(new File(cdfService.getSheetCacheDir().getAbsolutePath()), sheetId);
    }

    private static File makeSheetDataDir(File sheetCacheDir, String sheetId) {
        return new File(FilenameUtils.concat((String)sheetCacheDir.getAbsolutePath(), (String)(sheetId + "_" + Long.toHexString(sCounter.getAndIncrement()))));
    }

    private CDFSheetFactory() {
    }
}

