/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedSheet;
import com.ibm.neo.dataimport.cdf.sheet.impl.PartitionedSheet;
import com.ibm.neo.io.CSVWriter;
import java.io.File;
import java.io.IOException;

public class Sheet2CSV {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            throw new IllegalArgumentException("Expected 2 arguments: <sheet-dir> <csv-file>");
        }
        File sheetDir = new File(args[0]);
        File csvFile = new File(args[1]);
        String sheetId = sheetDir.getName();
        ICDFSheet sheet = null;
        sheet = new File(sheetDir, "sheet.partitions.journal").exists() ? new PartitionedSheet(sheetId, sheetDir) : new PagedSheet(sheetId, sheetDir);
        sheet.loadMetadata();
        try (ICDFSheetReader reader = sheet.openReader();){
            ICDFRowCursor cur = reader.cursor();
            Sheet2CSV.writeCSV(csvFile, cur, sheet.getColumnCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCSV(File csvFile, ICDFRowCursor cur, int columnCount) throws IOException {
        try (CSVWriter writer = new CSVWriter(csvFile, ',', "\n", Character.valueOf('\"'), "");){
            Object[] out = new Object[columnCount];
            ICDFCell[] cells = new ICDFCell[columnCount];
            while (cur.next()) {
                int i;
                ICDFRow row = cur.getRow();
                cells = row.getCells(cells);
                for (i = 0; i < row.getCellCount(); ++i) {
                    out[i] = cells[i].objectValue();
                }
                for (i = row.getCellCount(); i < columnCount; ++i) {
                    out[i] = null;
                }
                writer.writeRecord(out);
            }
        }
    }
}

