/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet;

import com.ibm.json.java.JSONArray;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.persist.ion.IONArray;
import java.io.IOException;

public class Sheet2JSONArray {
    private static final long MAX_DATE = 253402300799000L;

    public static JSONArray toIONArray(ICDFSheet sheet) throws IOException {
        return Sheet2JSONArray.toJSONArray(sheet, sheet.getRowCount(), -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray toJSONArray(ICDFSheet sheet, long maxRows, long numColumns) throws IOException {
        try (ICDFSheetReader reader = null;){
            reader = sheet.openReader();
            ICDFRowCursor cursor = reader.cursor();
            long numRows = Math.min(sheet.getRowCount(), maxRows);
            IONArray rows = new IONArray((int)numRows);
            for (long rowIndex = 0L; rowIndex < numRows; ++rowIndex) {
                if (!cursor.next()) {
                    throw new IOException("Row " + rowIndex + " in sheet " + sheet.getId() + " is expected to exist.");
                }
                ICDFRow row = cursor.getRow();
                long rowLength = numColumns < 0L ? (long)Sheet2JSONArray.determineRowLength(row) : numColumns;
                IONArray ionRow = new IONArray((int)rowLength);
                int cellIndex = 0;
                while ((long)cellIndex < rowLength) {
                    if (cellIndex < row.getCellCount()) {
                        ionRow.add(Sheet2JSONArray.cell2Primitive(row.getCell(cellIndex)));
                    } else {
                        ionRow.add(null);
                    }
                    ++cellIndex;
                }
                rows.add((Object)ionRow);
            }
            JSONArray jSONArray = (JSONArray)rows.toJSONArtifact();
            return jSONArray;
        }
    }

    private static int determineRowLength(ICDFRow row) {
        for (int i = row.getCellCount() - 1; i >= 0; --i) {
            ICDFCell cell = row.getCell(i);
            if (cell == null || cell.isNull()) continue;
            return i + 1;
        }
        return 0;
    }

    private static Object cell2Primitive(ICDFCell cell) {
        switch (cell.getDataType()) {
            case STRING: {
                return cell.stringValue();
            }
            case CHAR: {
                return Character.valueOf(cell.charValue());
            }
            case BOOLEAN: {
                return cell.booleanValue();
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                if (cell.longValue() > 253402300799000L) {
                    return null;
                }
                return cell.stringValue();
            }
            case INT8: {
                return cell.byteValue();
            }
            case INT16: {
                return cell.shortValue();
            }
            case INT32: {
                return cell.intValue();
            }
            case INT64: {
                return cell.longValue();
            }
            case FLOAT32: {
                if (Float.isInfinite(cell.floatValue()) || Float.isNaN(cell.floatValue())) {
                    return null;
                }
                return Float.valueOf(cell.floatValue());
            }
            case FLOAT64: {
                if (Double.isInfinite(cell.doubleValue()) || Double.isNaN(cell.doubleValue())) {
                    return null;
                }
                return cell.doubleValue();
            }
            case DECIMAL64: {
                return cell.bigDecimalValue();
            }
        }
        throw new RuntimeException("Unsupported cell type: " + cell.getDataType());
    }
}

