/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.DateFormatUtils;

public abstract class AbstractCell
implements ICDFCell {
    @Override
    public final Object objectValue() {
        if (this.isNull()) {
            return null;
        }
        switch (this.getDataType()) {
            case BOOLEAN: {
                return this.booleanValue();
            }
            case INT8: {
                return this.byteValue();
            }
            case INT16: {
                return this.shortValue();
            }
            case CHAR: {
                return Character.valueOf(this.charValue());
            }
            case INT32: {
                return this.intValue();
            }
            case FLOAT32: {
                return Float.valueOf(this.floatValue());
            }
            case STRING: {
                return this.stringValue();
            }
            case INT64: {
                return this.longValue();
            }
            case FLOAT64: {
                return this.doubleValue();
            }
            case DECIMAL64: {
                return this.bigDecimalValue();
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return this.dateValue();
            }
        }
        throw new RuntimeException("Illegal data type code: " + this.getDataType());
    }

    public String toString() {
        if (this.isNull()) {
            return "<null>";
        }
        switch (this.getDataType()) {
            case STRING: {
                return "'" + this.stringValue() + "'";
            }
            case TIME: {
                return DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.format(this.dateValue());
            }
            case DATE: {
                return DateFormatUtils.ISO_DATE_FORMAT.format(this.dateValue());
            }
            case TIMESTAMP: {
                return DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(this.dateValue());
            }
            case FLOAT32: {
                return new BigDecimal(this.floatValue()).setScale(4, RoundingMode.HALF_UP).toPlainString();
            }
            case FLOAT64: {
                return new BigDecimal(this.doubleValue()).setScale(4, RoundingMode.HALF_UP).toPlainString();
            }
            case DECIMAL64: {
                return this.bigDecimalValue().setScale(4, RoundingMode.HALF_UP).toPlainString();
            }
        }
        return String.valueOf(this.objectValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ICDFCell)) {
            return false;
        }
        ICDFCell other = (ICDFCell)o;
        return new EqualsBuilder().append((Object)this.getDataType(), (Object)other.getDataType()).append((Object)this.getDecorations(), (Object)other.getDecorations()).append(this.isNull(), other.isNull()).append(this.objectValue(), other.objectValue()).isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.getDataType());
        hcb.append(this.isNull());
        hcb.append((Object)this.getDecorations());
        if (!this.isNull()) {
            hcb.append(this.objectValue());
        }
        return hcb.toHashCode();
    }
}

