/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class AbstractRow
implements ICDFRow {
    protected AbstractRow() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRowIndex()).append(':').append('[');
        if (this.isEmpty()) {
            sb.append(']');
        } else {
            for (int i = 0; i < this.getCellCount(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getCell(i).toString());
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.getRowIndex());
        for (int i = 0; i < this.getCellCount(); ++i) {
            hcb.append((Object)this.getCell(i));
        }
        return hcb.toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ICDFRow)) {
            return false;
        }
        ICDFRow other = (ICDFRow)o;
        if (this.getRowIndex() != other.getRowIndex()) {
            return false;
        }
        if (this.getCellCount() != other.getCellCount()) {
            return false;
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            if (this.getCell(i).equals(other.getCell(i))) continue;
            return false;
        }
        return true;
    }
}

