/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.io.VarIntCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

final class BlockPartitionJournal {
    private static final IntLongPair MAX_PAIR = new IntLongPair(Integer.MAX_VALUE, Long.MAX_VALUE);
    private int mPartitionCount;
    private ArrayList<ArrayList<IntLongPair>> mPartitionBlocks;
    private ArrayList<IntLongPair> mBlockPartitions;
    private boolean mOptimized = false;

    public BlockPartitionJournal() {
        this.mPartitionCount = 0;
        this.mPartitionBlocks = new ArrayList();
        this.mBlockPartitions = null;
    }

    public BlockPartitionJournal(int numPartitions) {
        this.mPartitionCount = numPartitions;
        this.mPartitionBlocks = new ArrayList(this.mPartitionCount);
        for (int i = 0; i < this.mPartitionCount; ++i) {
            this.mPartitionBlocks.add(new ArrayList());
        }
        this.mBlockPartitions = null;
    }

    public IntLongPair getLastBlockRow(int partitionIndex) throws IllegalStateException {
        if (partitionIndex < 0) {
            throw new IllegalArgumentException("partitionIndex < 0");
        }
        if (this.mOptimized) {
            throw new IllegalStateException("Operation is invalid after journal is optimized");
        }
        if (partitionIndex >= this.mPartitionBlocks.size()) {
            return null;
        }
        ArrayList<IntLongPair> blocks = this.mPartitionBlocks.get(partitionIndex);
        if (blocks.isEmpty()) {
            return null;
        }
        return blocks.get(blocks.size() - 1);
    }

    public void addBlockRow(int partitionIndex, int blockIndex, long rowIndex) throws IllegalStateException {
        if (this.mOptimized) {
            throw new IllegalStateException("Operation is invalid after journal is optimized");
        }
        this.mPartitionBlocks.get(partitionIndex).add(new IntLongPair(blockIndex, rowIndex));
    }

    public IntLongPair getPartitionRow(int blockIndex) throws IllegalStateException {
        if (!this.mOptimized) {
            this.optimize();
        }
        return this.mBlockPartitions.get(blockIndex);
    }

    public void optimize() {
        int i;
        if (this.mOptimized) {
            return;
        }
        int numPartitions = this.mPartitionBlocks.size();
        Iterator[] iters = new Iterator[numPartitions];
        IntLongPair[] candidates = new IntLongPair[numPartitions];
        int totalBlocks = 0;
        for (i = 0; i < numPartitions; ++i) {
            iters[i] = this.mPartitionBlocks.get(i).iterator();
            totalBlocks += this.mPartitionBlocks.get(i).size();
        }
        this.mBlockPartitions = new ArrayList(Math.max(1, totalBlocks));
        for (i = 0; i < totalBlocks; ++i) {
            IntLongPair minBlock = MAX_PAIR;
            int minPartition = -1;
            for (int j = 0; j < numPartitions; ++j) {
                if (null == candidates[j] && iters[j].hasNext()) {
                    candidates[j] = (IntLongPair)iters[j].next();
                }
                if (null == candidates[j] || candidates[j].getFirst() >= minBlock.getFirst()) continue;
                minBlock = candidates[j];
                minPartition = j;
            }
            if (-1 == minPartition) {
                throw new IllegalStateException("Internal error: No candidate partition for block " + i);
            }
            this.mBlockPartitions.add(new IntLongPair(minPartition, minBlock.getSecond()));
            candidates[minPartition] = null;
        }
        this.mPartitionBlocks = null;
        this.mOptimized = true;
    }

    public void clear() {
        this.mPartitionBlocks = new ArrayList(Math.max(1, this.mPartitionCount));
        for (int i = 0; i < this.mPartitionCount; ++i) {
            this.mPartitionBlocks.add(new ArrayList());
        }
        this.mBlockPartitions = null;
        this.mOptimized = false;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.optimize();
        VarIntCoder.writeUnsignedVarInt((int)this.mPartitionCount, (OutputStream)out);
        VarIntCoder.writeUnsignedVarInt((int)this.mBlockPartitions.size(), (OutputStream)out);
        for (IntLongPair p : this.mBlockPartitions) {
            VarIntCoder.writeUnsignedVarInt((int)p.getFirst(), (OutputStream)out);
            VarIntCoder.writeUnsignedVarLong((long)p.getSecond(), (OutputStream)out);
        }
    }

    public void writeTo(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(out);
        }
    }

    public void readFrom(InputStream in) throws IOException {
        this.mPartitionCount = VarIntCoder.readUnsignedVarInt((InputStream)in);
        int numBlocks = VarIntCoder.readUnsignedVarInt((InputStream)in);
        this.mPartitionBlocks = null;
        this.mBlockPartitions = new ArrayList(numBlocks);
        this.mOptimized = true;
        for (int i = 0; i < numBlocks; ++i) {
            this.mBlockPartitions.add(new IntLongPair(VarIntCoder.readUnsignedVarInt((InputStream)in), VarIntCoder.readUnsignedVarLong((InputStream)in)));
        }
    }

    public void readFrom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.readFrom(in);
        }
    }

    public static final class IntLongPair {
        private final int mFirst;
        private final long mSecond;

        public IntLongPair(int first, long second) {
            this.mFirst = first;
            this.mSecond = second;
        }

        public int getFirst() {
            return this.mFirst;
        }

        public long getSecond() {
            return this.mSecond;
        }

        public String toString() {
            return String.format("[first=%d, second=%d]", this.mFirst, this.mSecond);
        }
    }
}

