/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.CDFSheetFactory;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.cdf.sheet.NoSuchSheetException;
import com.ibm.neo.io.ArchiveUtils;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.TTLCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSheetLibrary
implements ICDFSheetLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSheetLibrary.class);
    private static final String ARCHIVE_EXTENSION = ".tar";
    private static final String MANIFEST_FILENAME = "archive.manifest";
    private final File mCacheDir;
    private final File mArchiveDir;
    private final ConcurrentHashMap<String, ManifestEntry> mEntries = new ConcurrentHashMap();
    private final TTLCache<String, ICDFSheet> mSheetCache = new TTLCache(10L, TimeUnit.MINUTES);

    public LocalSheetLibrary(File cacheDir, File archiveDir) {
        this.mCacheDir = cacheDir;
        this.mArchiveDir = archiveDir;
        this.loadManifest();
    }

    @Override
    public ICDFSheetLibrary.IManifestEntry[] getManifest() throws IOException {
        return this.mEntries.values().toArray(new ICDFSheetLibrary.IManifestEntry[this.mEntries.size()]);
    }

    @Override
    public ICDFSheetLibrary.IManifestEntry getManifestEntry(String sheetId) throws IOException, NoSuchSheetException {
        ManifestEntry entry = this.mEntries.get(sheetId);
        if (null == entry || !entry.isValid()) {
            throw new NoSuchSheetException(sheetId);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICDFSheet load(String sheetId) throws IOException, NoSuchSheetException {
        ManifestEntry entry = this.mEntries.get(sheetId);
        if (null == entry || !entry.isValid()) {
            throw new NoSuchSheetException(sheetId);
        }
        ICDFSheet sheet = (ICDFSheet)this.mSheetCache.get((Object)sheetId);
        if (null != sheet) {
            return sheet;
        }
        ManifestEntry manifestEntry = entry;
        synchronized (manifestEntry) {
            File archiveFile = new File(FilenameUtils.concat((String)this.mArchiveDir.getAbsolutePath(), (String)entry.getArchiveName()));
            if (!archiveFile.exists()) {
                entry.invalidate();
                this.mSheetCache.invalidate((Object)sheetId);
                this.mEntries.remove(sheetId);
                this.saveManifest();
                throw new NoSuchSheetException(sheetId);
            }
            sheet = entry.isPartitioned() ? CDFSheetFactory.createPartitionedSheet(entry.getSheetId(), this.mCacheDir) : CDFSheetFactory.createSheet(entry.getSheetId(), this.mCacheDir);
            boolean loadSuccess = false;
            try {
                ArchiveUtils.untarDirectory((File)archiveFile, (File)sheet.getDataDirectory());
                sheet.loadMetadata();
                loadSuccess = true;
            }
            finally {
                if (!loadSuccess) {
                    sheet.destroy();
                }
            }
            this.mSheetCache.put((Object)sheetId, (Object)sheet);
            return sheet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(ICDFSheet sheet) throws IOException {
        ManifestEntry entry;
        File archiveFile;
        block6: {
            if (!this.mArchiveDir.exists()) {
                FileUtils.forceMkdir((File)this.mArchiveDir);
            }
            archiveFile = new File(FilenameUtils.concat((String)this.mArchiveDir.getAbsolutePath(), (String)(sheet.getId() + ARCHIVE_EXTENSION)));
            entry = null;
            do {
                if (null != (entry = this.mEntries.get(sheet.getId())) && !entry.isValid()) {
                    this.mEntries.remove(sheet.getId(), entry);
                    entry = null;
                }
                if (null != entry) break block6;
                entry = sheet.isPartitioned() ? new ManifestEntry(sheet.getId(), archiveFile.getName(), true, new Date()) : new ManifestEntry(sheet.getId(), archiveFile.getName(), false, new Date());
            } while (null != this.mEntries.putIfAbsent(sheet.getId(), entry));
            this.mSheetCache.put((Object)sheet.getId(), (Object)sheet);
        }
        ManifestEntry manifestEntry = entry;
        synchronized (manifestEntry) {
            entry.setLastUpdateDate(new Date());
            ArchiveUtils.tarDirectory((File)archiveFile, (File)sheet.getDataDirectory());
            entry.setSize(archiveFile.length());
        }
        this.saveManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String sheetId) throws IOException, NoSuchSheetException {
        ManifestEntry entry = this.mEntries.remove(sheetId);
        if (null != entry) {
            ManifestEntry manifestEntry = entry;
            synchronized (manifestEntry) {
                try {
                    entry.invalidate();
                    File archiveFile = new File(FilenameUtils.concat((String)this.mArchiveDir.getAbsolutePath(), (String)entry.getArchiveName()));
                    if (archiveFile.exists()) {
                        FileUtils.forceDelete((File)archiveFile);
                    }
                }
                finally {
                    this.mSheetCache.invalidate((Object)sheetId);
                }
            }
        }
        throw new NoSuchSheetException(sheetId);
        this.saveManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        try {
            Iterator<ManifestEntry> iterator = this.mEntries.values().iterator();
            while (iterator.hasNext()) {
                ManifestEntry entry;
                ManifestEntry manifestEntry = entry = iterator.next();
                synchronized (manifestEntry) {
                    entry.invalidate();
                    this.mSheetCache.invalidate((Object)entry.getSheetId());
                }
            }
            if (this.mArchiveDir.exists()) {
                FileUtils.deleteQuietly((File)this.mArchiveDir);
            }
        }
        finally {
            this.mEntries.clear();
            this.saveManifest();
        }
    }

    @Override
    public boolean isCached(String sheetId) {
        return this.mSheetCache.containsKey((Object)sheetId);
    }

    @Override
    public void uncache(String sheetId) throws IOException {
        this.mSheetCache.invalidate((Object)sheetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dispose() {
        try {
            this.saveManifest();
        }
        catch (IOException ex) {
            LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
        try {
            Iterator<ManifestEntry> iterator = this.mEntries.values().iterator();
            while (iterator.hasNext()) {
                ManifestEntry entry;
                ManifestEntry manifestEntry = entry = iterator.next();
                synchronized (manifestEntry) {
                    entry.invalidate();
                    this.mSheetCache.invalidate((Object)entry.getSheetId());
                }
            }
            return;
        }
        finally {
            this.mEntries.clear();
        }
    }

    private synchronized void loadManifest() {
        File manifestFile = new File(FilenameUtils.concat((String)this.mArchiveDir.getAbsolutePath(), (String)MANIFEST_FILENAME));
        if (manifestFile.exists()) {
            this.mEntries.clear();
            try (DataInputStream in = new DataInputStream(new FileInputStream(manifestFile));){
                int numEntries = VarIntCoder.readUnsignedVarInt((InputStream)in);
                for (int i = 0; i < numEntries; ++i) {
                    ManifestEntry entry = new ManifestEntry();
                    entry.readFrom(in);
                    this.mEntries.put(entry.getSheetId(), entry);
                }
            }
            catch (IOException ex) {
                if (!manifestFile.delete()) {
                    LOG.error("Failed to delete manifest file: {}", (Object)manifestFile.getAbsoluteFile());
                }
                LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void saveManifest() throws IOException {
        if (!this.mArchiveDir.exists()) {
            FileUtils.forceMkdir((File)this.mArchiveDir);
        }
        File manifestFile = new File(FilenameUtils.concat((String)this.mArchiveDir.getAbsolutePath(), (String)MANIFEST_FILENAME));
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(manifestFile));){
            VarIntCoder.writeUnsignedVarInt((int)this.mEntries.size(), (OutputStream)out);
            Iterator<ManifestEntry> iterator = this.mEntries.values().iterator();
            while (iterator.hasNext()) {
                ManifestEntry e;
                ManifestEntry manifestEntry = e = iterator.next();
                synchronized (manifestEntry) {
                    e.writeTo(out);
                }
            }
            return;
        }
    }

    private static final class ManifestEntry
    implements ICDFSheetLibrary.IManifestEntry {
        private String mSheetId;
        private String mArchiveName;
        private boolean mPartitioned;
        private volatile boolean mInvalid = false;
        private Date mLastUpdateDate;
        private long mSize = 0L;

        private ManifestEntry() {
        }

        private ManifestEntry(String sheetId, String archiveName, boolean isPartioned, Date lastUpdateDate) {
            this.mSheetId = sheetId;
            this.mArchiveName = archiveName;
            this.mPartitioned = isPartioned;
            this.mLastUpdateDate = lastUpdateDate;
        }

        private boolean isValid() {
            return !this.mInvalid;
        }

        private void invalidate() {
            this.mInvalid = true;
        }

        @Override
        public String getSheetId() {
            return this.mSheetId;
        }

        @Override
        public String getArchiveName() {
            return this.mArchiveName;
        }

        @Override
        public boolean isPartitioned() {
            return this.mPartitioned;
        }

        @Override
        public Date getLastUpdateDate() {
            return this.mLastUpdateDate;
        }

        private void setLastUpdateDate(Date lastUpdateDate) {
            this.mLastUpdateDate = lastUpdateDate;
        }

        @Override
        public long getSize() {
            return this.mSize;
        }

        void setSize(long size) {
            this.mSize = size;
        }

        private void writeTo(DataOutputStream out) throws IOException {
            out.writeUTF(this.mSheetId);
            out.writeUTF(this.mArchiveName);
            out.writeBoolean(this.mPartitioned);
            out.writeLong(this.mLastUpdateDate.getTime());
            out.writeLong(this.mSize);
        }

        private void readFrom(DataInputStream in) throws IOException {
            this.mSheetId = in.readUTF();
            this.mArchiveName = in.readUTF();
            this.mPartitioned = in.readBoolean();
            this.mLastUpdateDate = new Date(in.readLong());
            this.mSize = in.readLong();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

