/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibraryFactory;
import com.ibm.neo.dataimport.cdf.sheet.impl.LocalSheetLibrary;
import com.ibm.neo.exception.MissingRequiredPropertyException;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class LocalSheetLibraryFactory
implements ICDFSheetLibraryFactory {
    public static final String PROP_ARCHIVE_DIR = "com.ibm.neo.dataimport.sheet.local.archive-dir";

    @Override
    public ICDFSheetLibrary create(CDFService service) throws Exception {
        String archiveDirStr = service.getConfiguration().getProperty(PROP_ARCHIVE_DIR);
        if (null == archiveDirStr || archiveDirStr.length() == 0) {
            throw new MissingRequiredPropertyException(PROP_ARCHIVE_DIR);
        }
        File archiveDir = new File(archiveDirStr);
        if (!archiveDir.exists()) {
            FileUtils.forceMkdir((File)archiveDir);
        }
        return new LocalSheetLibrary(service.getSheetCacheDir(), archiveDir);
    }
}

