/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.file.FilePageStore;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionary;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedDictionaryReader;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedDictionaryWriter;
import com.ibm.neo.io.ByteBufferPool;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

final class PagedDictionary
implements ICDFDictionary {
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File mPageFile;
    private final ByteBufferPool mBufferPool;
    private final IPageStore mPageStore;

    public PagedDictionary(File pageFile, ByteBufferPool bufferPool) throws IOException {
        this.mPageFile = pageFile;
        this.mBufferPool = bufferPool;
        this.mPageStore = new FilePageStore(this.mPageFile, this.mBufferPool.getBufferSize());
    }

    IPageStore getPageStore() {
        return this.mPageStore;
    }

    ByteBufferPool getBufferPool() {
        return this.mBufferPool;
    }

    @Override
    public ICDFDictionaryReader openReader() throws IOException {
        return new PagedDictionaryReader(this);
    }

    @Override
    public ICDFDictionaryWriter openWriter() throws IOException {
        return new PagedDictionaryWriter(this);
    }

    @Override
    public void clear() throws IOException {
        this.mPageStore.clear();
    }
}

