/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.paging.IPageReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionary;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryReader;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedDictionary;
import com.ibm.neo.io.ByteBufferPool;
import com.ibm.neo.io.StringDecoder;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.BitMask;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.slf4j.LoggerFactory;

final class PagedDictionaryReader
implements ICDFDictionaryReader {
    private final PagedDictionary mDictionary;
    private final IPageReader mPageReader;
    private final ByteBufferPool.BufferSmartRef mPageBufRef;
    private final StringDecoder mDecoder = new StringDecoder(PagedDictionary.UTF_8);
    private final int mPageSize;
    private final int mNumPositionBits;
    private final int mNumIndexBits;
    private final long mPagePositionMask;
    private final long mPageIndexMask;
    private final HashMap<Long, String> mKey2Str = new HashMap();
    private long mCurrentPageIndex = -1L;
    private boolean mClosed = false;

    public PagedDictionaryReader(PagedDictionary dictionary) throws IOException {
        this.mDictionary = dictionary;
        this.mPageReader = this.mDictionary.getPageStore().openReader();
        this.mPageBufRef = this.mDictionary.getBufferPool().allocate();
        this.mPageSize = this.mDictionary.getBufferPool().getBufferSize();
        this.mNumPositionBits = (int)Math.ceil(Math.log(this.mPageSize) / Math.log(2.0));
        this.mNumIndexBits = 64 - this.mNumPositionBits;
        this.mPagePositionMask = BitMask.fillLow64((int)this.mNumPositionBits);
        this.mPageIndexMask = BitMask.fillLow64((int)this.mNumIndexBits);
    }

    @Override
    public ICDFDictionary getDictionary() {
        return this.mDictionary;
    }

    @Override
    public String lookup(long key) throws IOException {
        this.assertNotClosed();
        String str = this.mKey2Str.get(key);
        if (null != str) {
            return str;
        }
        long pageIndex = this.getPageIndex(key);
        int pagePos = this.getPagePosition(key);
        if (this.mCurrentPageIndex != pageIndex) {
            this.loadPage(pageIndex);
        }
        ByteBuffer pageBuf = this.mPageBufRef.get();
        pageBuf.clear();
        pageBuf.position(pagePos);
        int utf8DataLen = VarIntCoder.getUnsignedVarInt((ByteBuffer)pageBuf);
        pageBuf.limit(pageBuf.position() + utf8DataLen);
        str = this.mDecoder.decode(pageBuf);
        this.mKey2Str.put(key, str);
        return str;
    }

    private long getPageIndex(long key) {
        return key >> this.mNumPositionBits & this.mPageIndexMask;
    }

    private int getPagePosition(long key) {
        return (int)(key & this.mPagePositionMask);
    }

    private void loadPage(long pageIndex) throws IOException {
        ByteBuffer pageBuf = this.mPageBufRef.get();
        pageBuf.clear();
        this.mPageReader.read(pageIndex, pageBuf);
        pageBuf.clear();
        this.mCurrentPageIndex = pageIndex;
        this.mKey2Str.clear();
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        try {
            this.mPageReader.close();
        }
        finally {
            this.mPageBufRef.release();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                LoggerFactory.getLogger(this.getClass()).warn("Detected a finalized resource that was not properly closed: " + this.toString());
                this.close();
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error("Error caught in finalizer", t);
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("PagedDictionary was closed");
        }
    }
}

