/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionary;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedDictionary;
import com.ibm.neo.io.ByteBufferPool;
import com.ibm.neo.io.StringEncoder;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.BitMask;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.LoggerFactory;

final class PagedDictionaryWriter
implements ICDFDictionaryWriter {
    private final PagedDictionary mDictionary;
    private final IPageRandomAccess mPageRandomAccess;
    private final ByteBufferPool.BufferSmartRef mPageBufRef;
    private final StringEncoder mEncoder;
    private final int mPageSize;
    private final int mNumOffsetBits;
    private final int mNumIndexBits;
    private final long mPagePositionMask;
    private final long mPageIndexMask;
    private final HashMap<String, Long> mStr2Key = new HashMap();
    private long mPageCount = 0L;
    private int mPagePosition = 0;
    private boolean mDirtyPage = false;
    private boolean mClosed = false;

    public PagedDictionaryWriter(PagedDictionary dictionary) throws IOException {
        this.mDictionary = dictionary;
        this.mPageRandomAccess = this.mDictionary.getPageStore().openRandomAccess();
        this.mPageBufRef = this.mDictionary.getBufferPool().allocate();
        this.mEncoder = new StringEncoder(PagedDictionary.UTF_8);
        this.mPageSize = this.mDictionary.getBufferPool().getBufferSize();
        this.mNumOffsetBits = (int)Math.ceil(Math.log(this.mPageSize) / Math.log(2.0));
        this.mNumIndexBits = 64 - this.mNumOffsetBits;
        this.mPagePositionMask = BitMask.fillLow64((int)this.mNumOffsetBits);
        this.mPageIndexMask = BitMask.fillLow64((int)this.mNumIndexBits);
    }

    @Override
    public ICDFDictionary getDictionary() {
        return this.mDictionary;
    }

    @Override
    public long insert(String str) throws IOException {
        this.assertNotClosed();
        if (null == str) {
            throw new NullArgumentException("str");
        }
        if (str.length() + 1 > this.mPageSize) {
            throw new IllegalArgumentException("String length exceeds page size");
        }
        Long key = this.mStr2Key.get(str);
        if (null != key) {
            return key;
        }
        ByteBuffer pageBuf = this.mPageBufRef.get();
        ByteBuffer utf8Buf = this.mEncoder.encode((CharSequence)str);
        int totalLen = utf8Buf.remaining() + VarIntCoder.sizeofUnsignedVarInt((int)utf8Buf.remaining());
        if (this.mPageSize - this.mPagePosition < totalLen) {
            this.commitPage();
        }
        key = this.makeKey(this.mPageCount, this.mPagePosition);
        this.mStr2Key.put(str, key);
        VarIntCoder.putUnsignedVarInt((int)utf8Buf.remaining(), (ByteBuffer)pageBuf);
        pageBuf.put(utf8Buf);
        this.mPagePosition += totalLen;
        this.mDirtyPage = true;
        return key;
    }

    private void commitPage() throws IOException {
        if (this.mDirtyPage) {
            ByteBuffer buf = this.mPageBufRef.get();
            buf.clear();
            this.mPageRandomAccess.append(buf);
            buf.clear();
            this.mStr2Key.clear();
            ++this.mPageCount;
            this.mPagePosition = 0;
            this.mDirtyPage = false;
        }
    }

    private long makeKey(long pageIndex, int pageCharOffset) {
        return (pageIndex & this.mPageIndexMask) << this.mNumOffsetBits | (long)pageCharOffset & this.mPagePositionMask;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        try {
            this.commitPage();
            this.mPageRandomAccess.close();
        }
        finally {
            this.mPageBufRef.release();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                LoggerFactory.getLogger(this.getClass()).warn("Detected a finalized resource that was not properly closed: " + this.toString());
                this.close();
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error("Error caught in finalizer", t);
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("PagedDictionary was closed");
        }
    }
}

