/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.decoration.DecorationPool;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.file.FilePageStore;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionary;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedDictionary;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.RowPageJournal;
import com.ibm.neo.dataimport.cdf.sheet.impl.SheetMetadata;
import com.ibm.neo.dataimport.cdf.sheet.impl.SubSheet;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.dataimport.nodel.misc.CellRange;
import com.ibm.neo.io.ByteBufferPool;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PagedSheet
implements ICDFSheet {
    private static final int PAGE_SIZE = 0x100000;
    private final String mId;
    private final File mDataDir;
    private final File mMetadataFile;
    private final File mDictionaryFile;
    private final File mPageFile;
    private final File mRowJournalFile;
    private final File mDecorationPoolFile;
    private final SheetMetadata mMetadata = new SheetMetadata();
    private final DecorationPool mDecorationPool = new DecorationPool();
    private final IPageStore mPageStore;
    private final RowPageJournal mRowJournal = new RowPageJournal();
    private final ByteBufferPool mBufferPool;
    private final PagedDictionary mDictionary;
    private volatile boolean mDestroyed = false;

    public PagedSheet(String id, File dataDir) throws IOException {
        if (null == id) {
            throw new NullArgumentException("id");
        }
        if (null == dataDir) {
            throw new NullArgumentException("dataDir");
        }
        if (!dataDir.exists()) {
            FileUtils.forceMkdir((File)dataDir);
        }
        this.mId = id;
        this.mDataDir = dataDir;
        this.mMetadataFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.metadata"));
        this.mDictionaryFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.dictionary"));
        this.mPageFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.pages"));
        this.mRowJournalFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.rows.journal"));
        this.mDecorationPoolFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.decorations.pool"));
        this.mPageStore = new FilePageStore(this.mPageFile, 0x100000);
        this.mBufferPool = ByteBufferPool.getSharedInstance((int)0x100000, (ByteOrder)ByteOrder.BIG_ENDIAN, (boolean)false);
        this.mDictionary = new PagedDictionary(this.mDictionaryFile, this.mBufferPool);
    }

    @Override
    public SheetInfo getSheetInfo() {
        SheetInfo info = new SheetInfo();
        info.setSheetId(this.getId());
        info.setColumnExtent(this.getColumnCount());
        info.setRowExtent(this.getRowCount());
        return info;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public File getDataDirectory() {
        return this.mDataDir;
    }

    @Override
    public long getRowCount() {
        return this.mMetadata.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.mMetadata.getColumnCount();
    }

    @Override
    public int getMaxStringLength(int columnIndex) {
        return this.mMetadata.getMaxStringLengths()[columnIndex];
    }

    @Override
    public EDataType getDataType(int columnIndex) {
        if (this.mMetadata.getDataTypes() != null && columnIndex < this.mMetadata.getDataTypes().length) {
            return EDataType.values()[this.mMetadata.getDataTypes()[columnIndex]];
        }
        return EDataType.STRING;
    }

    DecorationPool getDecorationPool() {
        return this.mDecorationPool;
    }

    @Override
    public ICDFSheet subSheet(CellRange range) {
        return new SubSheet(this, range);
    }

    SheetMetadata getMetadata() {
        return this.mMetadata;
    }

    ICDFDictionary getDictionary() {
        return this.mDictionary;
    }

    IPageStore getPageStore() {
        return this.mPageStore;
    }

    RowPageJournal getRowJournal() {
        return this.mRowJournal;
    }

    ByteBufferPool getBufferPool() {
        return this.mBufferPool;
    }

    @Override
    public ICDFSheetWriter openWriter() throws IOException {
        this.assertNotDestroyed();
        return new PagedSheetWriter(this);
    }

    @Override
    public ICDFSheetReader openReader() throws IOException {
        this.assertNotDestroyed();
        return new PagedSheetReader(this);
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public void clear() throws IOException {
        this.assertNotDestroyed();
        this.mMetadata.setColumnCount(0);
        this.mMetadata.setRowCount(0L);
        this.mMetadata.setMaxStringLengths(new int[0]);
        this.mMetadata.setDataType(new int[0]);
        this.mDictionary.clear();
        this.mRowJournal.clear();
        this.mDecorationPool.clear();
        this.mPageStore.clear();
    }

    @Override
    public void loadMetadata() throws IOException {
        this.assertNotDestroyed();
        this.mMetadata.readFrom(this.mMetadataFile);
        this.mRowJournal.readFrom(this.mRowJournalFile);
        this.mDecorationPool.readFrom(this.mDecorationPoolFile);
    }

    @Override
    public void saveMetadata() throws IOException {
        this.assertNotDestroyed();
        this.mMetadata.writeTo(this.mMetadataFile);
        this.mRowJournal.writeTo(this.mRowJournalFile);
        this.mDecorationPool.writeTo(this.mDecorationPoolFile);
    }

    @Override
    public synchronized void destroy() throws IOException {
        if (this.mDestroyed) {
            return;
        }
        this.mDestroyed = true;
        this.mDictionary.clear();
        this.mDecorationPool.clear();
        this.mPageStore.destroy();
        try {
            FileUtils.forceDelete((File)this.mDataDir);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)this.mDataDir);
        }
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.mDestroyed;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private synchronized void assertNotDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("Sheet was destroyed.");
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("id", (Object)this.mId);
        builder.append("dataDir", (Object)this.mDataDir.getPath());
        return builder.toString();
    }
}

