/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.paging.IPageReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedSheet;
import com.ibm.neo.dataimport.cdf.sheet.impl.ScalarRowPage;
import com.ibm.neo.io.ByteBufferPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.LoggerFactory;

final class PagedSheetReader
implements ICDFSheetReader {
    private final PagedSheet mSheet;
    private final IPageReader mPageReader;
    private final ICDFDictionaryReader mDictReader;
    private boolean mClosed = false;

    public PagedSheetReader(PagedSheet sheet) throws IOException {
        this.mSheet = sheet;
        this.mPageReader = sheet.getPageStore().openReader();
        this.mDictReader = sheet.getDictionary().openReader();
    }

    @Override
    public ICDFSheet getSheet() {
        return this.mSheet;
    }

    @Override
    public ICDFRowCursor cursor() throws IOException {
        return new Cursor();
    }

    @Override
    public ICDFRow rowAt(long rowIndex) throws IOException {
        if (rowIndex < 0L) {
            throw new IllegalArgumentException("rowIndex < 0");
        }
        ICDFRowCursor cur = this.cursor();
        if (cur.position(rowIndex)) {
            return cur.getRow();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        try {
            this.mPageReader.close();
        }
        finally {
            this.mDictReader.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.mClosed) {
                LoggerFactory.getLogger(this.getClass()).warn("Detected a finalized resource that was not properly closed: " + this.toString());
                this.close();
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error("Error caught in finalizer", t);
        }
    }

    private final class Cursor
    implements ICDFRowCursor {
        private final ByteBufferPool.BufferSmartRef mBufRef;
        private int mPageIndex;
        private ScalarRowPage mPage;
        private ICDFRowCursor mPageCursor;
        private boolean mEndOfData = false;
        private ICDFRow mCurrentRow = null;

        Cursor() throws IOException {
            this.mBufRef = PagedSheetReader.this.mSheet.getBufferPool().allocate();
            this.gotoPage(0);
        }

        @Override
        public long getRowIndex() throws IOException {
            if (null == this.mCurrentRow) {
                return -1L;
            }
            return this.mCurrentRow.getRowIndex();
        }

        @Override
        public ICDFRow getRow() throws IOException {
            return this.mCurrentRow;
        }

        @Override
        public void beforeFirst() throws IOException {
            this.gotoPage(0);
        }

        @Override
        public boolean first() throws IOException {
            this.beforeFirst();
            return this.next();
        }

        @Override
        public boolean next() throws IOException {
            while (!this.mEndOfData) {
                if (this.mPageCursor.next()) {
                    this.mCurrentRow = this.mPageCursor.getRow();
                    return true;
                }
                if (this.nextPage()) continue;
                return false;
            }
            return false;
        }

        @Override
        public boolean position(long rowIndex) throws IOException {
            if (rowIndex < 0L) {
                throw new IllegalArgumentException("rowIndex < 0");
            }
            int pageIndex = PagedSheetReader.this.mSheet.getRowJournal().findPageForRow(rowIndex);
            if (pageIndex == -1) {
                return false;
            }
            if (pageIndex != this.mPageIndex) {
                this.gotoPage(pageIndex);
            }
            if (this.mPageCursor.position(rowIndex)) {
                this.mCurrentRow = this.mPageCursor.getRow();
                return true;
            }
            return false;
        }

        private boolean nextPage() throws IOException {
            return this.gotoPage(this.mPageIndex + 1);
        }

        private boolean gotoPage(int pageIndex) throws IOException {
            ByteBuffer buf = this.mBufRef.get();
            buf.clear();
            this.mCurrentRow = null;
            this.mPageIndex = pageIndex;
            if (PagedSheetReader.this.mPageReader.read(this.mPageIndex, buf)) {
                buf.flip();
                this.mPage = new ScalarRowPage(buf, PagedSheetReader.this.mSheet.getColumnCount(), PagedSheetReader.this.mSheet.getDecorationPool(), PagedSheetReader.this.mDictReader);
                this.mPageCursor = this.mPage.cursor();
                this.mEndOfData = false;
                return true;
            }
            this.mPage = null;
            this.mPageCursor = null;
            this.mEndOfData = true;
            return false;
        }
    }
}

