/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.paging.IPageAppender;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCellFactory;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryWriter;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedSheet;
import com.ibm.neo.dataimport.cdf.sheet.impl.ScalarCellFactory;
import com.ibm.neo.dataimport.cdf.sheet.impl.ScalarRow;
import com.ibm.neo.dataimport.cdf.sheet.impl.SheetMetadata;
import com.ibm.neo.dataimport.cdf.util.CDFUtils;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.io.ByteBufferPool;
import com.ibm.neo.util.FrequencyCounter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.slf4j.LoggerFactory;

final class PagedSheetWriter
implements ICDFSheetWriter {
    private static final short MAX_JUMP_ROWS = 32766;
    private final PagedSheet mSheet;
    private final IPageAppender mPageAppender;
    private final ICDFDictionaryWriter mDictionaryWriter;
    private final ICDFCellFactory mCellFactory;
    private final ByteBufferPool.BufferSmartRef mBufRef;
    private final ArrayList<ScalarRow> mJumpList;
    private final int mMaxJumpBytes;
    private final int mMaxJumpTagOverhead;
    private int mJumpByteCount = 0;
    private int mColumnCount = 0;
    private int[] mMaxStringLengths = new int[0];
    private int mPageRowCount = 0;
    private long mTotalRowCount = 0L;
    private int mPageCount = 0;
    private boolean mClosed = false;
    private FrequencyCounter<EDataType>[] mTypeCounts;

    public PagedSheetWriter(PagedSheet sheet) throws IOException {
        this.mSheet = sheet;
        this.mPageAppender = sheet.getPageStore().openAppender(false);
        this.mDictionaryWriter = sheet.getDictionary().openWriter();
        this.mCellFactory = new ScalarCellFactory(this.mDictionaryWriter, sheet.getDecorationPool());
        this.mBufRef = sheet.getBufferPool().allocate();
        this.mMaxJumpBytes = Math.min(32768, sheet.getPageStore().getPageSize() / 8);
        this.mMaxJumpTagOverhead = ScalarRow.makeJumpTag(32766, this.mMaxJumpBytes).getEncodedSize();
        this.mJumpList = new ArrayList(32766);
        this.putPageHeader(this.mBufRef.get(), 0L);
    }

    @Override
    public ICDFSheet getSheet() {
        return this.mSheet;
    }

    @Override
    public ICDFCellFactory getCellFactory() {
        return this.mCellFactory;
    }

    @Override
    public void appendEmptyRow() throws IOException {
        if (this.mClosed) {
            throw new IllegalStateException("writer was closed");
        }
        ScalarRow r = new ScalarRow(this.mTotalRowCount);
        ByteBuffer buf = this.mBufRef.get();
        int encodedSize = r.getEncodedSize();
        if (this.mPageRowCount >= 32766) {
            this.commitJumpList();
            this.commitPage();
        } else {
            if (this.mJumpByteCount + encodedSize > this.mMaxJumpBytes || this.mJumpByteCount + encodedSize + this.mMaxJumpTagOverhead >= buf.remaining()) {
                this.commitJumpList();
            }
            if (buf.remaining() < encodedSize + this.mMaxJumpTagOverhead) {
                this.commitPage();
            }
        }
        this.mJumpList.add(r);
        this.mJumpByteCount += encodedSize;
        ++this.mPageRowCount;
        ++this.mTotalRowCount;
        SheetMetadata metadata = this.mSheet.getMetadata();
        metadata.setRowCount(this.mTotalRowCount);
    }

    @Override
    public void appendRow(ICDFCell[] cells) throws IOException {
        if (this.mClosed) {
            throw new IllegalStateException("writer was closed");
        }
        if (null == cells || cells.length == 0) {
            this.appendEmptyRow();
        } else {
            ScalarRow r = new ScalarRow(this.mTotalRowCount, cells);
            ByteBuffer buf = this.mBufRef.get();
            int encodedSize = r.getEncodedSize();
            if (this.mPageRowCount >= 32766) {
                this.commitJumpList();
                this.commitPage();
            } else {
                if (this.mJumpByteCount + encodedSize > this.mMaxJumpBytes || this.mJumpByteCount + encodedSize + this.mMaxJumpTagOverhead >= buf.remaining()) {
                    this.commitJumpList();
                }
                if (buf.remaining() < encodedSize + this.mMaxJumpTagOverhead) {
                    this.commitPage();
                }
            }
            this.mJumpList.add(r);
            this.mJumpByteCount += encodedSize;
            ++this.mPageRowCount;
            ++this.mTotalRowCount;
            this.mColumnCount = Math.max(this.mColumnCount, cells.length);
            if (this.mTypeCounts == null) {
                this.mTypeCounts = new FrequencyCounter[cells.length];
            }
            this.mMaxStringLengths = this.mTotalRowCount == 1L ? CDFUtils.updateMaxStringLengths(cells, this.mMaxStringLengths) : CDFUtils.updateMaxStringLengths(cells, this.mMaxStringLengths, this.mTypeCounts);
            SheetMetadata metadata = this.mSheet.getMetadata();
            metadata.setColumnCount(this.mColumnCount);
            metadata.setRowCount(this.mTotalRowCount);
            metadata.setMaxStringLengths(this.mMaxStringLengths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        try {
            if (this.mPageRowCount > 0) {
                int[] dataTypes = new int[this.mColumnCount];
                for (int i = 0; i < this.mColumnCount; ++i) {
                    dataTypes[i] = i < this.mTypeCounts.length && this.mTypeCounts[i] != null && this.mTypeCounts[i].mostFrequentItem() != null ? ((EDataType)this.mTypeCounts[i].mostFrequentItem()).ordinal() : EDataType.STRING.ordinal();
                }
                this.mSheet.getMetadata().setDataType(dataTypes);
                this.commitJumpList();
                this.commitPage();
            }
        }
        finally {
            try {
                this.mPageAppender.close();
                this.mDictionaryWriter.close();
            }
            finally {
                this.mBufRef.release();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.mClosed) {
                LoggerFactory.getLogger(this.getClass()).warn("Detected a finalized resource that was not properly closed: " + this.toString());
                this.close();
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error("Error caught in finalizer", t);
        }
    }

    private void putPageHeader(ByteBuffer pageBuf, long rowNumber) {
        pageBuf.putLong(rowNumber);
    }

    private void commitJumpList() throws IOException {
        ByteBuffer buf = this.mBufRef.get();
        if (this.mPageRowCount > 0 && this.mJumpByteCount > 0) {
            ScalarRow jumpTag = ScalarRow.makeJumpTag((short)this.mPageRowCount, this.mJumpByteCount);
            jumpTag.encode(buf);
        }
        for (ScalarRow r : this.mJumpList) {
            r.encode(buf);
        }
        this.mJumpList.clear();
        this.mJumpByteCount = 0;
    }

    private void commitPage() throws IOException {
        ByteBuffer buf = this.mBufRef.get();
        this.mSheet.getRowJournal().put(this.mPageCount, this.mTotalRowCount - (long)this.mPageRowCount, this.mPageRowCount);
        if (buf.hasRemaining()) {
            ScalarRow.END_OF_PAGE.encode(buf);
        }
        buf.clear();
        this.mPageAppender.append(buf);
        buf.clear();
        this.putPageHeader(buf, this.mTotalRowCount);
        this.mPageRowCount = 0;
        ++this.mPageCount;
    }
}

