/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFPartitionedSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFPartitionedSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.BlockPartitionJournal;
import com.ibm.neo.dataimport.cdf.sheet.impl.PagedSheet;
import com.ibm.neo.dataimport.cdf.sheet.impl.PartitionedSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.impl.PartitionedSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.SheetMetadata;
import com.ibm.neo.dataimport.cdf.sheet.impl.SubSheet;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.dataimport.nodel.misc.CellRange;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PartitionedSheet
implements ICDFPartitionedSheet {
    private final String mId;
    private final File mDataDir;
    private final File mMetadataFile;
    private final File mPartitionJournalFile;
    private final SheetMetadata mMetadata = new SheetMetadata();
    private final BlockPartitionJournal mPartitionJournal;
    private ArrayList<PagedSheet> mPartitions = new ArrayList();
    private volatile boolean mDestroyed = false;

    public PartitionedSheet(String id, File dataDir) throws IOException {
        if (null == id) {
            throw new NullArgumentException("id");
        }
        if (null == dataDir) {
            throw new NullArgumentException("dataDir");
        }
        this.mId = id;
        this.mDataDir = dataDir;
        this.mMetadataFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.metadata"));
        this.mPartitionJournalFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.partitions.journal"));
        this.mPartitionJournal = new BlockPartitionJournal();
    }

    public PartitionedSheet(String id, File dataDir, int numPartitions, int blockSize) throws IOException {
        if (null == id) {
            throw new NullArgumentException("id");
        }
        if (null == dataDir) {
            throw new NullArgumentException("dataDir");
        }
        if (numPartitions < 1) {
            throw new IllegalArgumentException("numPartitions < 1");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize < 1");
        }
        this.mId = id;
        this.mDataDir = dataDir;
        this.mMetadataFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.metadata"));
        this.mPartitionJournalFile = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)"sheet.partitions.journal"));
        this.mPartitionJournal = new BlockPartitionJournal(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            this.createPartition();
        }
        this.mMetadata.setPartitionCount(numPartitions);
        this.mMetadata.setBlockSize(blockSize);
    }

    private void createPartition() throws IOException {
        int index = this.mPartitions.size();
        File partitionDataDir = new File(FilenameUtils.concat((String)this.mDataDir.getAbsolutePath(), (String)("partition" + index)));
        if (!partitionDataDir.exists()) {
            FileUtils.forceMkdir((File)partitionDataDir);
        }
        this.mPartitions.add(new PagedSheet(this.mId + "-partition" + index, partitionDataDir));
    }

    @Override
    public SheetInfo getSheetInfo() {
        SheetInfo info = new SheetInfo();
        info.setSheetId(this.getId());
        info.setColumnExtent(this.getColumnCount());
        info.setRowExtent(this.getRowCount());
        return info;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public File getDataDirectory() {
        return this.mDataDir;
    }

    @Override
    public ICDFSheetWriter openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICDFPartitionedSheetWriter openPartitionedWriter() throws IOException {
        this.assertNotDestroyed();
        return new PartitionedSheetWriter(this);
    }

    @Override
    public ICDFSheetReader openReader() throws IOException {
        this.assertNotDestroyed();
        return new PartitionedSheetReader(this);
    }

    @Override
    public long getRowCount() {
        return this.mMetadata.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.mMetadata.getColumnCount();
    }

    @Override
    public int getMaxStringLength(int columnIndex) {
        return this.mMetadata.getMaxStringLengths()[columnIndex];
    }

    @Override
    public EDataType getDataType(int columnIndex) {
        if (this.mMetadata.getDataTypes() != null && columnIndex < this.mMetadata.getDataTypes().length) {
            return EDataType.values()[this.mMetadata.getDataTypes()[columnIndex]];
        }
        return EDataType.STRING;
    }

    @Override
    public boolean isPartitioned() {
        return true;
    }

    @Override
    public int getPartitionCount() {
        return this.mPartitions.size();
    }

    @Override
    public int getBlockSize() {
        return this.mMetadata.getBlockSize();
    }

    @Override
    public ICDFSheet getPartition(int index) throws IndexOutOfBoundsException {
        return this.mPartitions.get(index);
    }

    @Override
    public ICDFSheet subSheet(CellRange range) {
        return new SubSheet(this, range);
    }

    SheetMetadata getMetadata() {
        return this.mMetadata;
    }

    BlockPartitionJournal getPartitionJournal() {
        return this.mPartitionJournal;
    }

    @Override
    public void clear() throws IOException {
        this.assertNotDestroyed();
        this.mMetadata.setRowCount(0L);
        this.mMetadata.setColumnCount(0);
        this.mMetadata.setMaxStringLengths(new int[0]);
        this.mMetadata.setDataType(new int[0]);
        this.mPartitionJournal.clear();
        for (PagedSheet t : this.mPartitions) {
            t.clear();
        }
    }

    @Override
    public void loadMetadata() throws IOException {
        this.assertNotDestroyed();
        this.mMetadata.readFrom(this.mMetadataFile);
        this.mPartitionJournal.readFrom(this.mPartitionJournalFile);
        while (this.mPartitions.size() < this.mMetadata.getPartitionCount()) {
            this.createPartition();
        }
        while (this.mPartitions.size() > this.mMetadata.getPartitionCount()) {
            this.mPartitions.remove(this.mPartitions.size() - 1);
        }
        for (int i = 0; i < this.mMetadata.getPartitionCount(); ++i) {
            this.mPartitions.get(i).loadMetadata();
        }
    }

    @Override
    public void saveMetadata() throws IOException {
        this.assertNotDestroyed();
        this.mMetadata.writeTo(this.mMetadataFile);
        this.mPartitionJournal.writeTo(this.mPartitionJournalFile);
        for (PagedSheet t : this.mPartitions) {
            t.saveMetadata();
        }
    }

    @Override
    public synchronized void destroy() throws IOException {
        if (this.mDestroyed) {
            return;
        }
        this.mDestroyed = true;
        if (this.mMetadataFile.exists() && !this.mMetadataFile.delete()) {
            this.mMetadataFile.deleteOnExit();
        }
        this.mPartitionJournal.clear();
        if (this.mPartitionJournalFile.exists() && !this.mPartitionJournalFile.delete()) {
            this.mPartitionJournalFile.deleteOnExit();
        }
        for (PagedSheet t : this.mPartitions) {
            t.destroy();
        }
        if (this.mDataDir.exists()) {
            FileUtils.deleteQuietly((File)this.mDataDir);
        }
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.mDestroyed;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private synchronized void assertNotDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("Sheet was destroyed");
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("id", (Object)this.mId);
        builder.append("dataDir", (Object)this.mDataDir.getPath());
        builder.append("partitionCount", this.getPartitionCount());
        return builder.toString();
    }
}

