/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.impl.BlockPartitionJournal;
import com.ibm.neo.dataimport.cdf.sheet.impl.PartitionedSheet;
import com.ibm.neo.dataimport.cdf.sheet.impl.SubRow;
import com.ibm.neo.dataimport.nodel.misc.ColumnRange;
import java.io.IOException;

class PartitionedSheetReader
implements ICDFSheetReader {
    private final PartitionedSheet mSheet;
    private final ICDFSheetReader[] mParitionReaders;
    private boolean mClosed = false;

    public PartitionedSheetReader(PartitionedSheet sheet) throws IOException {
        this.mSheet = sheet;
        int numPartitions = this.mSheet.getPartitionCount();
        this.mParitionReaders = new ICDFSheetReader[numPartitions];
        for (int i = 0; i < numPartitions; ++i) {
            this.mParitionReaders[i] = this.mSheet.getPartition(i).openReader();
        }
    }

    @Override
    public ICDFSheet getSheet() {
        return this.mSheet;
    }

    @Override
    public ICDFRowCursor cursor() throws IOException {
        return new Cursor();
    }

    @Override
    public ICDFRow rowAt(long rowIndex) throws IOException {
        if (rowIndex < 0L) {
            throw new IllegalArgumentException("rowIndex < 0");
        }
        if (rowIndex >= this.mSheet.getRowCount()) {
            return null;
        }
        int blockSize = this.mSheet.getMetadata().getBlockSize();
        int startBlock = (int)(rowIndex / (long)blockSize);
        BlockPartitionJournal.IntLongPair pair = this.mSheet.getPartitionJournal().getPartitionRow(startBlock);
        int blockPos = (int)(rowIndex % (long)blockSize);
        ICDFRow r = this.mParitionReaders[pair.getFirst()].rowAt(pair.getSecond() + (long)blockPos);
        if (null != r) {
            return new SubRow(rowIndex, r, ColumnRange.ALL);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        for (ICDFSheetReader r : this.mParitionReaders) {
            r.close();
        }
    }

    private final class Cursor
    implements ICDFRowCursor {
        private int mPartitionIndex;
        private int mBlockIndex;
        private ICDFRowCursor[] mPartitionCursors;
        private ICDFRow mCurrentRow;
        private boolean mEndOfData = false;

        public Cursor() throws IOException {
            this.mPartitionCursors = new ICDFRowCursor[PartitionedSheetReader.this.mParitionReaders.length];
            for (int i = 0; i < PartitionedSheetReader.this.mParitionReaders.length; ++i) {
                this.mPartitionCursors[i] = PartitionedSheetReader.this.mParitionReaders[i].cursor();
            }
            this.beforeFirst();
        }

        @Override
        public long getRowIndex() throws IOException {
            if (null == this.mCurrentRow) {
                return -1L;
            }
            return this.mCurrentRow.getRowIndex();
        }

        @Override
        public ICDFRow getRow() throws IOException {
            return this.mCurrentRow;
        }

        @Override
        public void beforeFirst() throws IOException {
            this.mEndOfData = false;
            this.mCurrentRow = null;
            for (int i = 0; i < this.mPartitionCursors.length; ++i) {
                this.mPartitionCursors[i].beforeFirst();
            }
            if (PartitionedSheetReader.this.mSheet.getPartitionCount() == 0 || PartitionedSheetReader.this.mSheet.getRowCount() == 0L) {
                this.mPartitionIndex = 0;
            } else {
                BlockPartitionJournal.IntLongPair journalPair = PartitionedSheetReader.this.mSheet.getPartitionJournal().getPartitionRow(0);
                this.mPartitionIndex = journalPair.getFirst();
            }
            this.mBlockIndex = 0;
        }

        @Override
        public boolean first() throws IOException {
            this.beforeFirst();
            return this.next();
        }

        @Override
        public boolean next() throws IOException {
            if (this.mEndOfData) {
                return false;
            }
            long nextRowIndex = null != this.mCurrentRow ? this.mCurrentRow.getRowIndex() + 1L : 0L;
            if (nextRowIndex >= PartitionedSheetReader.this.mSheet.getMetadata().getRowCount()) {
                this.mEndOfData = true;
                return false;
            }
            int blockSize = PartitionedSheetReader.this.mSheet.getMetadata().getBlockSize();
            int nextBlockIndex = (int)(nextRowIndex / (long)blockSize);
            if (nextBlockIndex != this.mBlockIndex) {
                BlockPartitionJournal.IntLongPair journalPair = PartitionedSheetReader.this.mSheet.getPartitionJournal().getPartitionRow(nextBlockIndex);
                if (!this.mPartitionCursors[journalPair.getFirst()].position(journalPair.getSecond())) {
                    throw new IOException(String.format("Row (%d) belonging to block (%d) was not found in partition (%d)", journalPair.getSecond(), nextBlockIndex, journalPair.getFirst()));
                }
                this.mPartitionIndex = journalPair.getFirst();
                this.mBlockIndex = nextBlockIndex;
            } else if (!this.mPartitionCursors[this.mPartitionIndex].next()) {
                throw new IOException(String.format("Unexpected end of of block (%d) was encountered in partition (%d)", this.mBlockIndex, this.mPartitionIndex));
            }
            ICDFRow r = this.mPartitionCursors[this.mPartitionIndex].getRow();
            this.mCurrentRow = new SubRow(nextRowIndex, r, ColumnRange.ALL);
            return true;
        }

        @Override
        public boolean position(long rowIndex) throws IOException {
            if (rowIndex < 0L) {
                throw new IllegalArgumentException("rowIndex < 0");
            }
            if (rowIndex >= PartitionedSheetReader.this.mSheet.getMetadata().getRowCount()) {
                return false;
            }
            int blockSize = PartitionedSheetReader.this.mSheet.getMetadata().getBlockSize();
            int nextBlockIndex = (int)(rowIndex / (long)blockSize);
            int offsetInBlock = (int)(rowIndex % (long)blockSize);
            BlockPartitionJournal.IntLongPair journalPair = PartitionedSheetReader.this.mSheet.getPartitionJournal().getPartitionRow(nextBlockIndex);
            long rowInPartition = journalPair.getSecond() + (long)offsetInBlock;
            if (nextBlockIndex != this.mBlockIndex) {
                if (!this.mPartitionCursors[journalPair.getFirst()].position(rowInPartition)) {
                    throw new IOException(String.format("Row (%d) belonging to block (%d) was not found in partition (%d)", rowInPartition, nextBlockIndex, journalPair.getFirst()));
                }
                this.mPartitionIndex = journalPair.getFirst();
                this.mBlockIndex = nextBlockIndex;
            } else if (!this.mPartitionCursors[this.mPartitionIndex].position(rowInPartition)) {
                throw new IOException(String.format("Row (%d) belonging to block (%d) was not found in partition (%d)", rowInPartition, this.mBlockIndex, this.mPartitionIndex));
            }
            ICDFRow r = this.mPartitionCursors[this.mPartitionIndex].getRow();
            this.mCurrentRow = new SubRow(rowIndex, r, ColumnRange.ALL);
            return true;
        }
    }
}

