/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCellFactory;
import com.ibm.neo.dataimport.cdf.sheet.ICDFPartitionedSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFPartitionedSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.BlockPartitionJournal;
import com.ibm.neo.dataimport.cdf.sheet.impl.PartitionedSheet;
import java.io.IOException;

class PartitionedSheetWriter
implements ICDFPartitionedSheetWriter {
    private final PartitionedSheet mSheet;
    private final ICDFSheetWriter[] mPartitionWriters;
    private boolean mClosed = false;

    public PartitionedSheetWriter(PartitionedSheet table) throws IOException {
        this.mSheet = table;
        this.mPartitionWriters = new ICDFSheetWriter[this.mSheet.getPartitionCount()];
        for (int i = 0; i < this.mSheet.getPartitionCount(); ++i) {
            this.mPartitionWriters[i] = this.mSheet.getPartition(i).openWriter();
        }
    }

    @Override
    public ICDFPartitionedSheet getSheet() {
        return this.mSheet;
    }

    @Override
    public ICDFCellFactory getCellFactory(int partitionIndex) {
        return this.mPartitionWriters[partitionIndex].getCellFactory();
    }

    @Override
    public void appendEmptyRow(int partitionIndex, int blockIndex) throws IOException {
        ICDFSheetWriter writer = this.mPartitionWriters[partitionIndex];
        writer.appendEmptyRow();
        BlockPartitionJournal journal = this.mSheet.getPartitionJournal();
        BlockPartitionJournal.IntLongPair pair = journal.getLastBlockRow(partitionIndex);
        if (null == pair || pair.getFirst() != blockIndex) {
            journal.addBlockRow(partitionIndex, blockIndex, writer.getSheet().getRowCount() - 1L);
        }
    }

    @Override
    public void appendRow(int partitionIndex, int blockIndex, ICDFCell[] cells) throws IOException {
        ICDFSheetWriter writer = this.mPartitionWriters[partitionIndex];
        writer.appendRow(cells);
        BlockPartitionJournal journal = this.mSheet.getPartitionJournal();
        BlockPartitionJournal.IntLongPair pair = journal.getLastBlockRow(partitionIndex);
        if (null == pair || pair.getFirst() != blockIndex) {
            journal.addBlockRow(partitionIndex, blockIndex, writer.getSheet().getRowCount() - 1L);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        int maxColumnCount = 0;
        long totalRowCount = 0L;
        int[] maxStringLengths = new int[]{};
        int[] dataTypes = new int[]{};
        for (ICDFSheetWriter partitionWriter : this.mPartitionWriters) {
            partitionWriter.close();
            ICDFSheet partitionSheet = partitionWriter.getSheet();
            maxColumnCount = Math.max(maxColumnCount, partitionSheet.getColumnCount());
            totalRowCount += partitionSheet.getRowCount();
            if (maxStringLengths.length < maxColumnCount) {
                int[] old = maxStringLengths;
                maxStringLengths = new int[maxColumnCount];
                System.arraycopy(old, 0, maxStringLengths, 0, old.length);
            }
            if (dataTypes.length < maxColumnCount) {
                int[] oldCounts = dataTypes;
                dataTypes = new int[maxColumnCount];
                System.arraycopy(oldCounts, 0, dataTypes, 0, oldCounts.length);
            }
            for (int i = 0; i < partitionSheet.getColumnCount(); ++i) {
                maxStringLengths[i] = Math.max(maxStringLengths[i], partitionSheet.getMaxStringLength(i));
                dataTypes[i] = partitionSheet.getDataType(i).ordinal();
            }
        }
        this.mSheet.getMetadata().setColumnCount(maxColumnCount);
        this.mSheet.getMetadata().setMaxStringLengths(maxStringLengths);
        this.mSheet.getMetadata().setRowCount(totalRowCount);
        this.mSheet.getMetadata().setDataType(dataTypes);
        this.mSheet.getPartitionJournal().optimize();
    }
}

