/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.CDFSheetFactory;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.cdf.sheet.NoSuchSheetException;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.io.ArchiveUtils;
import com.ibm.neo.persist.IFile;
import com.ibm.neo.persist.IFileBucket;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.util.TTLCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoSheetLibrary
implements ICDFSheetLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(RepoSheetLibrary.class);
    private static final String ARCHIVE_EXTENSION = ".tar";
    private static final String KEY_FILENAME = "filename";
    private static final String KEY_PARTITIONED = "partitioned";
    private static final String KEY_LAST_UPDATE_DATE = "last-update-date";
    private final File mCacheDir;
    private final TTLCache<String, ICDFSheet> mSheetCache = new TTLCache(10L, TimeUnit.MINUTES);

    public RepoSheetLibrary(File cacheDir) {
        if (null == cacheDir) {
            throw new NullArgumentException("cacheDir");
        }
        this.mCacheDir = cacheDir;
    }

    @Override
    public ICDFSheetLibrary.IManifestEntry[] getManifest() throws IOException {
        ArrayList<ManifestEntry> entries = new ArrayList<ManifestEntry>();
        try {
            IFileBucket sheetFS = ImportPersistence.getSheetsFS();
            for (IFile f : sheetFS.findAll()) {
                entries.add(new ManifestEntry(f));
            }
        }
        catch (PersistenceException ex) {
            throw new IOException("Failed to load manifest entries from repository: " + ex.getMessage(), ex);
        }
        return entries.toArray(new ICDFSheetLibrary.IManifestEntry[entries.size()]);
    }

    @Override
    public ICDFSheetLibrary.IManifestEntry getManifestEntry(String sheetId) throws IOException, NoSuchSheetException {
        try {
            IFileBucket sheetFS = ImportPersistence.getSheetsFS();
            IFile f = sheetFS.findOne(sheetId + ARCHIVE_EXTENSION);
            if (null == f) {
                throw new NoSuchSheetException(sheetId);
            }
            return new ManifestEntry(f);
        }
        catch (PersistenceException ex) {
            throw new IOException("Failed to load manifest entry from repository: " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICDFSheet load(String sheetId) throws IOException, NoSuchSheetException {
        ICDFSheet sheet = (ICDFSheet)this.mSheetCache.get((Object)sheetId);
        if (null != sheet && !sheet.isDestroyed()) {
            return sheet;
        }
        try {
            IFileBucket sheetFS = ImportPersistence.getSheetsFS();
            IFile f = sheetFS.findOne(sheetId + ARCHIVE_EXTENSION);
            if (null == f) {
                throw new NoSuchSheetException(sheetId);
            }
            ManifestEntry entry = new ManifestEntry(f);
            sheet = entry.isPartitioned() ? CDFSheetFactory.createPartitionedSheet(sheetId, this.mCacheDir) : CDFSheetFactory.createSheet(sheetId, this.mCacheDir);
            InputStream in = f.open();
            boolean loadSuccess = false;
            try {
                ArchiveUtils.untarDirectory((InputStream)in, (File)sheet.getDataDirectory());
                sheet.loadMetadata();
                loadSuccess = true;
            }
            finally {
                in.close();
                if (!loadSuccess) {
                    sheet.destroy();
                }
            }
        }
        catch (PersistenceException ex) {
            throw new IOException("Failed to load sheet from repository: " + ex.getMessage(), ex);
        }
        this.mSheetCache.put((Object)sheetId, (Object)sheet);
        return sheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(ICDFSheet sheet) throws IOException {
        try {
            IFileBucket sheetFS = ImportPersistence.getSheetsFS();
            String filename = sheet.getId() + ARCHIVE_EXTENSION;
            sheetFS.remove(new QueryBuilder().equalTo(KEY_FILENAME, (Object)filename).toDocument());
            File tempTar = File.createTempFile("tmp-sheet", "tar");
            try {
                ArchiveUtils.tarDirectory((File)tempTar, (File)sheet.getDataDirectory());
                try (FileInputStream in = new FileInputStream(tempTar);){
                    IFile f = sheetFS.createFile((InputStream)in, filename, "application/x-tar");
                    f.setMetadataValue(KEY_LAST_UPDATE_DATE, (Object)new Date());
                    f.setMetadataValue(KEY_PARTITIONED, (Object)sheet.isPartitioned());
                    f.save();
                }
            }
            finally {
                if (!tempTar.delete()) {
                    LOG.error("Failed to delete temp tar file: {}", (Object)tempTar.getAbsolutePath());
                }
            }
        }
        catch (PersistenceException ex) {
            throw new IOException("Failed to save sheet to repository: " + ex.getMessage(), ex);
        }
        this.mSheetCache.put((Object)sheet.getId(), (Object)sheet);
    }

    @Override
    public void remove(String sheetId) throws IOException, NoSuchSheetException {
        this.mSheetCache.invalidate((Object)sheetId);
        try {
            IFileBucket sheetFS = ImportPersistence.getSheetsFS();
            String filename = sheetId + ARCHIVE_EXTENSION;
            sheetFS.remove(new QueryBuilder().equalTo(KEY_FILENAME, (Object)filename).toDocument());
        }
        catch (PersistenceException ex) {
            throw new IOException("Failed to remove sheet from repository: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void clear() throws IOException {
        this.mSheetCache.clear();
        try {
            IFileBucket sheetFS = ImportPersistence.getSheetsFS();
            sheetFS.clear();
        }
        catch (PersistenceException ex) {
            throw new IOException("Failed to clear sheets from repository: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void dispose() {
        this.mSheetCache.clear();
    }

    @Override
    public boolean isCached(String sheetId) {
        return this.mSheetCache.containsKey((Object)sheetId);
    }

    @Override
    public void uncache(String sheetId) throws IOException {
        this.mSheetCache.invalidate((Object)sheetId);
    }

    public void clearCache() {
        this.mSheetCache.clear();
    }

    private static final class ManifestEntry
    implements ICDFSheetLibrary.IManifestEntry {
        private final String mSheetId;
        private final String mArchiveName;
        private final boolean mPartitioned;
        private final Date mLastUpdateDate;
        private final long mSize;

        private ManifestEntry(IFile file) {
            this.mArchiveName = file.getFilename();
            this.mSheetId = file.getFilename().substring(0, this.mArchiveName.length() - RepoSheetLibrary.ARCHIVE_EXTENSION.length());
            this.mPartitioned = Boolean.TRUE.equals(file.getMetadataValue(RepoSheetLibrary.KEY_PARTITIONED));
            this.mLastUpdateDate = (Date)file.getMetadataValue(RepoSheetLibrary.KEY_LAST_UPDATE_DATE);
            this.mSize = file.getLength();
        }

        @Override
        public String getSheetId() {
            return this.mSheetId;
        }

        @Override
        public String getArchiveName() {
            return this.mArchiveName;
        }

        @Override
        public boolean isPartitioned() {
            return this.mPartitioned;
        }

        @Override
        public Date getLastUpdateDate() {
            return this.mLastUpdateDate;
        }

        @Override
        public long getSize() {
            return this.mSize;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

