/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.io.VarIntCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

final class RowPageJournal {
    private final ArrayList<Entry> mEntries = new ArrayList();

    RowPageJournal() {
    }

    public int getPageCount() {
        return this.mEntries.size();
    }

    public void clear() {
        this.mEntries.clear();
    }

    public void put(int pageIndex, long firstRowIndex, int rowCount) {
        if (pageIndex < 0) {
            throw new IllegalArgumentException("pageIndex < 0");
        }
        if (firstRowIndex < 0L) {
            throw new IllegalArgumentException("firstRowNumber < 0");
        }
        if (rowCount < 0) {
            throw new IllegalArgumentException("rowCount < 0");
        }
        while (this.mEntries.size() - 1 < pageIndex) {
            this.mEntries.add(null);
        }
        this.mEntries.set(pageIndex, new Entry(firstRowIndex, rowCount));
    }

    public long getFirstRowIndex(int pageIndex) {
        if (pageIndex < 0) {
            throw new IllegalArgumentException("pageIndex < 0");
        }
        if (pageIndex >= this.mEntries.size()) {
            return -1L;
        }
        Entry e = this.mEntries.get(pageIndex);
        if (null == e) {
            return -1L;
        }
        return e.getFirstRowIndex();
    }

    public int getRowCount(int pageIndex) {
        if (pageIndex < 0) {
            throw new IllegalArgumentException("pageIndex < 0");
        }
        if (pageIndex >= this.mEntries.size()) {
            return -1;
        }
        Entry e = this.mEntries.get(pageIndex);
        if (null == e) {
            return -1;
        }
        return e.getRowCount();
    }

    public int findPageForRow(long rowIndex) {
        Entry e;
        if (rowIndex < 0L) {
            throw new IllegalArgumentException("rowIndex < 0");
        }
        for (int pageId = 0; pageId < this.mEntries.size() && (e = this.mEntries.get(pageId)).getFirstRowIndex() <= rowIndex; ++pageId) {
            if (e.getFirstRowIndex() > rowIndex || e.getFirstRowIndex() + (long)e.getRowCount() <= rowIndex) continue;
            return pageId;
        }
        return -1;
    }

    public void writeTo(OutputStream out) throws IOException {
        VarIntCoder.writeUnsignedVarInt((int)this.mEntries.size(), (OutputStream)out);
        for (Entry e : this.mEntries) {
            VarIntCoder.writeUnsignedVarLong((long)e.getFirstRowIndex(), (OutputStream)out);
            VarIntCoder.writeUnsignedVarInt((int)e.getRowCount(), (OutputStream)out);
        }
    }

    public void writeTo(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(out);
        }
    }

    public void readFrom(InputStream in) throws IOException {
        int size = VarIntCoder.readUnsignedVarInt((InputStream)in);
        this.mEntries.clear();
        this.mEntries.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            this.mEntries.add(new Entry(VarIntCoder.readUnsignedVarLong((InputStream)in), VarIntCoder.readUnsignedVarInt((InputStream)in)));
        }
    }

    public void readFrom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.readFrom(in);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = 0; i < this.mEntries.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(i).append(':').append(this.mEntries.get(i));
        }
        sb.append('}');
        return sb.toString();
    }

    private static final class Entry {
        private final long mFirstRowIndex;
        private final int mRowCount;

        Entry(long firstRowNumber, int rowCount) {
            this.mFirstRowIndex = firstRowNumber;
            this.mRowCount = rowCount;
        }

        public long getFirstRowIndex() {
            return this.mFirstRowIndex;
        }

        public int getRowCount() {
            return this.mRowCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(this.mFirstRowIndex).append(", ").append(this.mFirstRowIndex + (long)this.mRowCount - 1L).append(']');
            return sb.toString();
        }
    }
}

