/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.DecorationMap;
import com.ibm.neo.dataimport.cdf.decoration.DecorationPool;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.AbstractCell;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.BitMask;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.commons.lang.NullArgumentException;

public final class ScalarCell
extends AbstractCell {
    private static final int BYTE_MASK32 = BitMask.fillLow32((int)8);
    private static final long BYTE_MASK64 = BitMask.fillLow64((int)8);
    private static final long SHORT_MASK64 = BitMask.fillLow64((int)16);
    private static final long INT_MASK64 = BitMask.fillLow64((int)32);
    private static final int DATA_TYPE_MASK32 = BitMask.fillRange32((int)3, (int)8);
    private static final int NULL_BIT32 = BitMask.fillRange32((int)2, (int)3);
    private static final int DECORATED_BIT32 = BitMask.fillRange32((int)1, (int)2);
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final EDataType mDataType;
    private final boolean mNull;
    private final long mScalarValue;
    private final int mNumericScale;
    private String mCachedString;
    private final ICDFDictionaryReader mDictReader;
    private final DecorationPool mDecorationPool;
    private final int[] mDecorationKeys;

    public static ScalarCell createNull(EDataType dataType) {
        return ScalarCell.createNull(dataType, null, null);
    }

    public static ScalarCell createNull(EDataType dataType, int[] decorationKeys, DecorationPool decorationPool) {
        return new ScalarCell(dataType, true, 0L, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createBoolean(boolean isNull, boolean value) {
        return ScalarCell.createBoolean(isNull, value, null, null);
    }

    public static ScalarCell createBoolean(boolean isNull, boolean value, int[] decorationKeys, DecorationPool decorationPool) {
        long scalarValue = 0L;
        if (!isNull) {
            scalarValue = value ? 1L : 0L;
        }
        return new ScalarCell(EDataType.BOOLEAN, isNull, scalarValue, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createInt8(boolean isNull, byte value) {
        return ScalarCell.createInt8(isNull, value, null, null);
    }

    public static ScalarCell createInt8(boolean isNull, byte value, int[] decorationKeys, DecorationPool decorationPool) {
        long scalarValue = 0L;
        if (!isNull) {
            scalarValue = (long)value & BYTE_MASK64;
        }
        return new ScalarCell(EDataType.INT8, isNull, scalarValue, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createInt16(boolean isNull, short value) {
        return ScalarCell.createInt16(isNull, value, null, null);
    }

    public static ScalarCell createInt16(boolean isNull, short value, int[] decorationKeys, DecorationPool decorationPool) {
        long scalarValue = 0L;
        if (!isNull) {
            scalarValue = (long)value & SHORT_MASK64;
        }
        return new ScalarCell(EDataType.INT16, isNull, scalarValue, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createInt32(boolean isNull, int value) {
        return ScalarCell.createInt32(isNull, value, null, null);
    }

    public static ScalarCell createInt32(boolean isNull, int value, int[] decorationKeys, DecorationPool decorationPool) {
        long scalarValue = 0L;
        if (!isNull) {
            scalarValue = (long)value & INT_MASK64;
        }
        return new ScalarCell(EDataType.INT32, isNull, scalarValue, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createInt64(boolean isNull, long value) {
        return ScalarCell.createInt64(isNull, value, null, null);
    }

    public static ScalarCell createInt64(boolean isNull, long value, int[] decorationKeys, DecorationPool decorationPool) {
        long scalarValue = 0L;
        if (!isNull) {
            scalarValue = value;
        }
        return new ScalarCell(EDataType.INT64, isNull, scalarValue, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createFloat32(boolean isNull, float value) {
        return ScalarCell.createFloat32(isNull, value, null, null);
    }

    public static ScalarCell createFloat32(boolean isNull, float value, int[] decorationKeys, DecorationPool decorationPool) {
        long scalarValue = 0L;
        if (!isNull) {
            scalarValue = (long)Float.floatToIntBits(value) & INT_MASK64;
        }
        return new ScalarCell(EDataType.FLOAT32, isNull, scalarValue, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createFloat64(boolean isNull, double value) {
        return ScalarCell.createFloat64(isNull, value, null, null);
    }

    public static ScalarCell createFloat64(boolean isNull, double value, int[] decorationKeys, DecorationPool decorationPool) {
        long scalarValue = 0L;
        if (!isNull) {
            scalarValue = Double.doubleToLongBits(value);
        }
        return new ScalarCell(EDataType.FLOAT64, isNull, scalarValue, decorationKeys, decorationPool, null);
    }

    public static ICDFCell createDecimal64(BigDecimal value) {
        return ScalarCell.createDecimal64(value, null, null);
    }

    public static ICDFCell createDecimal64(BigDecimal value, int[] decorationKeys, DecorationPool decorationPool) {
        if (null != value) {
            value = value.round(MathContext.DECIMAL64);
            return ScalarCell.createDecimal64(false, value.unscaledValue().longValue(), value.scale(), decorationKeys, decorationPool);
        }
        return ScalarCell.createDecimal64(true, 0L, 0, decorationKeys, decorationPool);
    }

    public static ScalarCell createDecimal64(boolean isNull, long unscaledValue, int scale) {
        return ScalarCell.createDecimal64(isNull, unscaledValue, scale, null, null);
    }

    public static ScalarCell createDecimal64(boolean isNull, long unscaledValue, int scale, int[] decorationKeys, DecorationPool decorationPool) {
        if (isNull) {
            return new ScalarCell(EDataType.DECIMAL64, isNull, 0L, 0, decorationKeys, decorationPool, null);
        }
        return new ScalarCell(EDataType.DECIMAL64, isNull, unscaledValue, scale, decorationKeys, decorationPool, null);
    }

    public static ICDFCell createChar(boolean isNull, char value) {
        return ScalarCell.createChar(isNull, value, null, null);
    }

    public static ICDFCell createChar(boolean isNull, char value, int[] decorationKeys, DecorationPool decorationPool) {
        long scalarValue = 0L;
        if (!isNull) {
            scalarValue = (long)value & SHORT_MASK64;
        }
        return new ScalarCell(EDataType.CHAR, isNull, scalarValue, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createString(boolean isNull, long stringKey, ICDFDictionaryReader dictReader) {
        return ScalarCell.createString(isNull, stringKey, null, null, dictReader);
    }

    public static ScalarCell createString(boolean isNull, long stringKey, int[] decorationKeys, DecorationPool decorationPool, ICDFDictionaryReader dictReader) {
        long scalarValue = 0L;
        if (!isNull) {
            if (null == dictReader) {
                throw new NullArgumentException("dictReader");
            }
            scalarValue = stringKey;
        }
        return new ScalarCell(EDataType.STRING, isNull, scalarValue, decorationKeys, decorationPool, dictReader);
    }

    public static ScalarCell createString(String value, ICDFDictionaryWriter dictWriter) {
        return ScalarCell.createString(value, null, null, dictWriter);
    }

    public static ScalarCell createString(String value, int[] decorationKeys, DecorationPool decorationPool, ICDFDictionaryWriter dictWriter) {
        boolean isNull = null == value;
        long scalarValue = 0L;
        if (!isNull) {
            try {
                scalarValue = dictWriter.insert(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ScalarCell cell = new ScalarCell(EDataType.STRING, isNull, scalarValue, decorationKeys, decorationPool, null);
        cell.setCachedString(value);
        return cell;
    }

    public static ScalarCell createDate(Date value) {
        return ScalarCell.createDate(value, null, null);
    }

    public static ScalarCell createDate(Date value, int[] decorationKeys, DecorationPool decorationPool) {
        if (null != value) {
            return new ScalarCell(EDataType.DATE, false, value.getTime(), decorationKeys, decorationPool, null);
        }
        return new ScalarCell(EDataType.DATE, true, 0L, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createTime(Date value) {
        return ScalarCell.createTime(value, null, null);
    }

    public static ScalarCell createTime(Date value, int[] decorationKeys, DecorationPool decorationPool) {
        if (null != value) {
            return new ScalarCell(EDataType.TIME, false, value.getTime(), decorationKeys, decorationPool, null);
        }
        return new ScalarCell(EDataType.TIME, true, 0L, decorationKeys, decorationPool, null);
    }

    public static ScalarCell createTimestamp(Date value) {
        return ScalarCell.createTimestamp(value, null, null);
    }

    public static ScalarCell createTimestamp(Date value, int[] decorationKeys, DecorationPool decorationPool) {
        if (null != value) {
            return new ScalarCell(EDataType.TIMESTAMP, false, value.getTime(), decorationKeys, decorationPool, null);
        }
        return new ScalarCell(EDataType.TIMESTAMP, true, 0L, decorationKeys, decorationPool, null);
    }

    ScalarCell(ByteBuffer cellBuf, DecorationPool decorationPool, ICDFDictionaryReader dictReader) {
        if (null == decorationPool) {
            throw new NullArgumentException("decorationPool");
        }
        int header = cellBuf.get() & BYTE_MASK32;
        this.mDataType = EDataType.fromOrdinal((int)((header & DATA_TYPE_MASK32) >> 3));
        this.mNull = 0 != (header & NULL_BIT32);
        boolean decorated = 0 != (header & DECORATED_BIT32);
        this.mDictReader = dictReader;
        this.mDecorationPool = decorationPool;
        if (this.mNull) {
            this.mScalarValue = 0L;
            this.mNumericScale = 0;
        } else {
            switch (this.getDataType()) {
                case BOOLEAN: 
                case INT8: {
                    this.mScalarValue = (long)cellBuf.get() & BYTE_MASK64;
                    this.mNumericScale = 0;
                    break;
                }
                case INT16: 
                case CHAR: {
                    this.mScalarValue = (long)cellBuf.getShort() & SHORT_MASK64;
                    this.mNumericScale = 0;
                    break;
                }
                case INT32: {
                    this.mScalarValue = (long)VarIntCoder.getSignedVarInt((ByteBuffer)cellBuf) & INT_MASK64;
                    this.mNumericScale = 0;
                    break;
                }
                case FLOAT32: {
                    this.mScalarValue = (long)cellBuf.getInt() & INT_MASK64;
                    this.mNumericScale = 0;
                    break;
                }
                case FLOAT64: {
                    this.mScalarValue = cellBuf.getLong();
                    this.mNumericScale = 0;
                    break;
                }
                case DECIMAL64: {
                    this.mScalarValue = VarIntCoder.getSignedVarLong((ByteBuffer)cellBuf);
                    this.mNumericScale = (short)VarIntCoder.getSignedVarInt((ByteBuffer)cellBuf);
                    break;
                }
                case STRING: {
                    this.mScalarValue = VarIntCoder.getUnsignedVarLong((ByteBuffer)cellBuf);
                    this.mNumericScale = 0;
                    break;
                }
                case INT64: 
                case DATE: 
                case TIME: 
                case TIMESTAMP: {
                    this.mScalarValue = VarIntCoder.getSignedVarLong((ByteBuffer)cellBuf);
                    this.mNumericScale = 0;
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal data type: " + this.getDataType());
                }
            }
        }
        if (decorated) {
            int numDecorations = VarIntCoder.getUnsignedVarInt((ByteBuffer)cellBuf);
            this.mDecorationKeys = new int[numDecorations];
            for (int i = 0; i < numDecorations; ++i) {
                this.mDecorationKeys[i] = VarIntCoder.getSignedVarInt((ByteBuffer)cellBuf);
            }
        } else {
            this.mDecorationKeys = EMPTY_INT_ARRAY;
        }
    }

    ScalarCell(EDataType dataType, boolean isNull, long scalarValue, int[] decorationKeys, DecorationPool decorationPool, ICDFDictionaryReader dictReader) {
        this.mDataType = dataType;
        this.mNull = isNull;
        this.mScalarValue = scalarValue;
        this.mNumericScale = 0;
        this.mDecorationKeys = decorationKeys;
        this.mDecorationPool = decorationPool;
        this.mDictReader = dictReader;
    }

    ScalarCell(EDataType dataType, boolean isNull, long scalarValue, int numericScale, int[] decorationKeys, DecorationPool decorationPool, ICDFDictionaryReader dictReader) {
        this.mDataType = dataType;
        this.mNull = isNull;
        this.mScalarValue = scalarValue;
        this.mNumericScale = numericScale;
        this.mDecorationKeys = decorationKeys;
        this.mDecorationPool = decorationPool;
        this.mDictReader = dictReader;
    }

    void setCachedString(String str) {
        this.mCachedString = str;
    }

    @Override
    public EDataType getDataType() {
        return this.mDataType;
    }

    public int getEncodedSize() {
        int size = 1;
        if (!this.isNull()) {
            switch (this.getDataType()) {
                case BOOLEAN: 
                case INT8: {
                    ++size;
                    break;
                }
                case INT16: 
                case CHAR: {
                    size += 2;
                    break;
                }
                case INT32: {
                    size += VarIntCoder.sizeofSignedVarInt((int)this.intValue());
                    break;
                }
                case FLOAT32: {
                    size += 4;
                    break;
                }
                case FLOAT64: {
                    size += 8;
                    break;
                }
                case DECIMAL64: {
                    size += VarIntCoder.sizeofSignedVarLong((long)this.getScalarValue());
                    size += VarIntCoder.sizeofSignedVarInt((int)this.getNumericScale());
                    break;
                }
                case STRING: {
                    size += VarIntCoder.sizeofUnsignedVarLong((long)this.longValue());
                    break;
                }
                case INT64: 
                case DATE: 
                case TIME: 
                case TIMESTAMP: {
                    size += VarIntCoder.sizeofSignedVarLong((long)this.getScalarValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal data type code: " + this.getDataType());
                }
            }
        }
        if (null != this.mDecorationKeys && this.mDecorationKeys.length > 0) {
            size += VarIntCoder.sizeofUnsignedVarInt((int)this.mDecorationKeys.length);
            for (int key : this.mDecorationKeys) {
                size += VarIntCoder.sizeofSignedVarInt((int)key);
            }
        }
        return size;
    }

    public void encode(ByteBuffer cellBuf) {
        int header = (this.getDataType().ordinal() & BYTE_MASK32) << 3;
        if (this.isNull()) {
            header |= NULL_BIT32;
        }
        if (null != this.mDecorationKeys && this.mDecorationKeys.length > 0) {
            header |= DECORATED_BIT32;
        }
        cellBuf.put((byte)(header & BYTE_MASK32));
        if (!this.isNull()) {
            switch (this.getDataType()) {
                case BOOLEAN: 
                case INT8: {
                    cellBuf.put(this.byteValue());
                    break;
                }
                case INT16: 
                case CHAR: {
                    cellBuf.putShort(this.shortValue());
                    break;
                }
                case INT32: {
                    VarIntCoder.putSignedVarInt((int)this.intValue(), (ByteBuffer)cellBuf);
                    break;
                }
                case FLOAT32: {
                    cellBuf.putInt(this.intValue());
                    break;
                }
                case FLOAT64: {
                    cellBuf.putLong(this.longValue());
                    break;
                }
                case DECIMAL64: {
                    VarIntCoder.putSignedVarLong((long)this.mScalarValue, (ByteBuffer)cellBuf);
                    VarIntCoder.putSignedVarInt((int)this.mNumericScale, (ByteBuffer)cellBuf);
                    break;
                }
                case STRING: {
                    VarIntCoder.putUnsignedVarLong((long)this.longValue(), (ByteBuffer)cellBuf);
                    break;
                }
                case INT64: 
                case DATE: 
                case TIME: 
                case TIMESTAMP: {
                    VarIntCoder.putSignedVarLong((long)this.longValue(), (ByteBuffer)cellBuf);
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal data type code: " + this.getDataType());
                }
            }
        }
        if (null != this.mDecorationKeys && this.mDecorationKeys.length > 0) {
            VarIntCoder.putUnsignedVarInt((int)this.mDecorationKeys.length, (ByteBuffer)cellBuf);
            for (int key : this.mDecorationKeys) {
                VarIntCoder.putSignedVarInt((int)key, (ByteBuffer)cellBuf);
            }
        }
    }

    @Override
    public boolean isNull() {
        return this.mNull;
    }

    public long getScalarValue() {
        return this.mScalarValue;
    }

    @Override
    public int getNumericScale() {
        return this.mNumericScale;
    }

    @Override
    public boolean booleanValue() {
        return 0L != this.mScalarValue;
    }

    @Override
    public byte byteValue() {
        return (byte)(BYTE_MASK64 & this.mScalarValue);
    }

    @Override
    public short shortValue() {
        return (short)(SHORT_MASK64 & this.mScalarValue);
    }

    @Override
    public char charValue() {
        return (char)this.shortValue();
    }

    @Override
    public int intValue() {
        return (int)(INT_MASK64 & this.mScalarValue);
    }

    @Override
    public long longValue() {
        return this.mScalarValue;
    }

    @Override
    public float floatValue() {
        return Float.intBitsToFloat(this.intValue());
    }

    @Override
    public double doubleValue() {
        return Double.longBitsToDouble(this.longValue());
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (this.mNull) {
            return null;
        }
        return BigDecimal.valueOf(this.mScalarValue, this.mNumericScale);
    }

    @Override
    public Date dateValue() {
        if (this.mNull) {
            return null;
        }
        return new Date(this.longValue());
    }

    @Override
    public String stringValue() {
        if (this.mNull) {
            return null;
        }
        if (EDataType.STRING == this.getDataType()) {
            if (null != this.mCachedString) {
                return this.mCachedString;
            }
            if (null != this.mDictReader) {
                try {
                    this.mCachedString = this.mDictReader.lookup(this.mScalarValue);
                    return this.mCachedString;
                }
                catch (IOException ex) {
                    throw new RuntimeException("An I/O arror occured in string dictionary", ex);
                }
            }
            throw new IllegalStateException("Dictionary reader was not specified!");
        }
        return this.toString();
    }

    @Override
    public DecorationMap getDecorations() {
        if (null != this.mDecorationKeys && this.mDecorationKeys.length > 0) {
            DecorationMap decorations = new DecorationMap();
            for (int i = 0; i < this.mDecorationKeys.length; ++i) {
                Decoration decoration = this.mDecorationPool.getDecoration(this.mDecorationKeys[i]);
                decorations.insert(decoration);
            }
            return decorations;
        }
        return null;
    }
}

