/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.DecorationMap;
import com.ibm.neo.dataimport.cdf.decoration.DecorationPool;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCellFactory;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.ScalarCell;
import com.ibm.neo.dataimport.nodel.EDataType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Date;
import java.util.EnumMap;

public class ScalarCellFactory
implements ICDFCellFactory {
    private static EnumMap<EDataType, ScalarCell> TYPE_2_NULL_CELL = new EnumMap(EDataType.class);
    private final ICDFDictionaryWriter mDictWriter;
    private final DecorationPool mDecorationPool;

    public ScalarCellFactory(ICDFDictionaryWriter dictWriter, DecorationPool decorationPool) {
        this.mDictWriter = dictWriter;
        this.mDecorationPool = decorationPool;
    }

    private int[] getDecorationKeys(DecorationMap decorations) {
        if (null == decorations) {
            return null;
        }
        int[] keys = new int[decorations.size()];
        int i = 0;
        for (Decoration d : decorations) {
            keys[i++] = this.mDecorationPool.keyOfOrInsert(d);
        }
        return keys;
    }

    @Override
    public ICDFCell createNull(EDataType dataType, DecorationMap decorations) {
        if (null == decorations || decorations.isEmpty()) {
            return TYPE_2_NULL_CELL.get(dataType);
        }
        return new ScalarCell(dataType, true, 0L, this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createBoolean(boolean value, DecorationMap decorations) {
        return new ScalarCell(EDataType.BOOLEAN, false, value ? 1L : 0L, this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createInt8(byte value, DecorationMap decorations) {
        return new ScalarCell(EDataType.INT8, false, value, this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createInt16(short value, DecorationMap decorations) {
        return new ScalarCell(EDataType.INT16, false, value, this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createInt32(int value, DecorationMap decorations) {
        return new ScalarCell(EDataType.INT32, false, value, this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createInt64(long value, DecorationMap decorations) {
        return new ScalarCell(EDataType.INT64, false, value, this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createFloat32(float value, DecorationMap decorations) {
        return new ScalarCell(EDataType.FLOAT32, false, Float.floatToIntBits(value), this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createFloat64(double value, DecorationMap decorations) {
        return new ScalarCell(EDataType.FLOAT64, false, Double.doubleToLongBits(value), this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createDecimal64(BigDecimal value, DecorationMap decorations) {
        value = value.round(MathContext.DECIMAL64);
        return new ScalarCell(EDataType.DECIMAL64, false, value.unscaledValue().longValue(), value.scale(), this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createDecimal64(long unscaledValue, int scale, DecorationMap decorations) {
        return new ScalarCell(EDataType.DECIMAL64, false, unscaledValue, scale, this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createChar(char value, DecorationMap decorations) {
        return new ScalarCell(EDataType.CHAR, false, value, this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createString(String value, DecorationMap decorations) {
        if (null == value) {
            return this.createNull(EDataType.STRING, decorations);
        }
        try {
            ScalarCell cell = new ScalarCell(EDataType.STRING, false, this.mDictWriter.insert(value), this.getDecorationKeys(decorations), this.mDecorationPool, null);
            cell.setCachedString(value);
            return cell;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ICDFCell createDate(Date value, DecorationMap decorations) {
        if (null == value) {
            return this.createNull(EDataType.DATE, decorations);
        }
        return new ScalarCell(EDataType.DATE, false, value.getTime(), this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createTime(Date value, DecorationMap decorations) {
        if (null == value) {
            return this.createNull(EDataType.TIME, decorations);
        }
        return new ScalarCell(EDataType.TIME, false, value.getTime(), this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    @Override
    public ICDFCell createTimestamp(Date value, DecorationMap decorations) {
        if (null == value) {
            return this.createNull(EDataType.TIMESTAMP, decorations);
        }
        return new ScalarCell(EDataType.TIMESTAMP, false, value.getTime(), this.getDecorationKeys(decorations), this.mDecorationPool, null);
    }

    static {
        for (EDataType t : EDataType.values()) {
            TYPE_2_NULL_CELL.put(t, new ScalarCell(t, true, 0L, null, null, null));
        }
    }
}

