/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.decoration.DecorationPool;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.impl.AbstractRow;
import com.ibm.neo.dataimport.cdf.sheet.impl.ScalarCell;
import com.ibm.neo.io.VarIntCoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ScalarRow
extends AbstractRow {
    private static final ScalarCell[] EMPTY_ROW_CELLS = new ScalarCell[0];
    public static final ScalarRow END_OF_PAGE = new ScalarRow(-1L);
    private final ByteBuffer mRowBuf;
    private final long mRowIndex;
    private final short mHeaderLength;
    private final int mDataLength;
    private final int mExpectedCellCount;
    private final ICDFDictionaryReader mDictReader;
    private final DecorationPool mDecorationPool;
    private ICDFCell[] mCells;
    private boolean mMaterialized = false;

    public static ScalarRow makeJumpTag(int rowJump, int byteJump) {
        if (rowJump <= 0) {
            throw new IllegalArgumentException("rowJump <= 0");
        }
        if (byteJump <= 0) {
            throw new IllegalArgumentException("byteJump <= 0");
        }
        long flags = -1L;
        flags &= (long)rowJump & 0xFFFFL ^ 0xFFFFFFFFFFFFFFFFL;
        return new ScalarRow(flags &= ((long)byteJump & 0xFFFFFFFFFFFFFFFFL) << 16 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public ScalarRow(ByteBuffer rowBuf, int expectedCellCount, DecorationPool decorationPool, ICDFDictionaryReader dictReader) {
        this.mRowBuf = rowBuf.slice().order(rowBuf.order());
        this.mCells = EMPTY_ROW_CELLS;
        this.mExpectedCellCount = expectedCellCount;
        this.mDecorationPool = decorationPool;
        this.mDictReader = dictReader;
        this.mRowIndex = VarIntCoder.getSignedVarLong((ByteBuffer)this.mRowBuf);
        this.mDataLength = this.mRowIndex < 0L ? 0 : VarIntCoder.getUnsignedVarInt((ByteBuffer)this.mRowBuf);
        this.mHeaderLength = (short)this.mRowBuf.position();
        this.mRowBuf.limit(this.mHeaderLength + this.mDataLength);
    }

    public ScalarRow(long rowIndex) {
        this.mRowBuf = null;
        this.mRowIndex = rowIndex;
        this.mCells = EMPTY_ROW_CELLS;
        this.mExpectedCellCount = 0;
        this.mMaterialized = true;
        this.mDataLength = 0;
        this.mDictReader = null;
        this.mDecorationPool = null;
        int headerLength = 0;
        headerLength += VarIntCoder.sizeofSignedVarLong((long)this.mRowIndex);
        if (this.mRowIndex >= 0L) {
            headerLength += VarIntCoder.sizeofUnsignedVarInt((int)this.mDataLength);
        }
        this.mHeaderLength = (short)headerLength;
    }

    public ScalarRow(long rowIndex, ICDFCell[] cells) {
        this.mRowBuf = null;
        this.mRowIndex = rowIndex;
        if (null == cells || cells.length == 0) {
            this.mCells = EMPTY_ROW_CELLS;
            this.mExpectedCellCount = 0;
        } else {
            this.mCells = new ScalarCell[cells.length];
            System.arraycopy(cells, 0, this.mCells, 0, cells.length);
            this.mExpectedCellCount = cells.length;
        }
        this.mDictReader = null;
        this.mDecorationPool = null;
        this.mMaterialized = true;
        if (this.mRowIndex >= 0L) {
            int dataLength = 0;
            for (ICDFCell c : this.mCells) {
                ScalarCell scalarCell = (ScalarCell)c;
                if (scalarCell == null) continue;
                dataLength += scalarCell.getEncodedSize();
            }
            this.mDataLength = dataLength;
        } else {
            this.mDataLength = 0;
        }
        int headerLength = 0;
        headerLength += VarIntCoder.sizeofSignedVarLong((long)this.mRowIndex);
        if (this.mRowIndex >= 0L) {
            headerLength += VarIntCoder.sizeofUnsignedVarInt((int)this.mDataLength);
        }
        this.mHeaderLength = (short)headerLength;
    }

    @Override
    public boolean isEmpty() {
        if (this.mMaterialized) {
            return 0 == this.mCells.length;
        }
        if (null != this.mRowBuf) {
            return 0 == this.mDataLength;
        }
        throw new IllegalStateException("Non-materialized row is not backed by a ByteBuffer!");
    }

    public boolean isEndOfPageTag() {
        return -1L == this.mRowIndex;
    }

    public boolean isJumpTag() {
        return this.mRowIndex < -1L;
    }

    public short getRowJump() {
        if (this.mRowIndex >= -1L) {
            throw new UnsupportedOperationException("not a jump tag");
        }
        return (short)((this.mRowIndex ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFL);
    }

    public int getByteJump() {
        if (this.mRowIndex >= -1L) {
            throw new UnsupportedOperationException("not a jump tag");
        }
        return (int)(((this.mRowIndex ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFF0000L) >> 16);
    }

    @Override
    public long getRowIndex() {
        return this.mRowIndex;
    }

    public int getEncodedSize() {
        return this.mHeaderLength + this.mDataLength;
    }

    public void encode(ByteBuffer buf) {
        VarIntCoder.putSignedVarLong((long)this.mRowIndex, (ByteBuffer)buf);
        if (this.mRowIndex >= 0L) {
            VarIntCoder.putUnsignedVarInt((int)this.mDataLength, (ByteBuffer)buf);
            if (null != this.mRowBuf) {
                this.mRowBuf.rewind();
                buf.put(this.mRowBuf);
            } else if (null != this.mCells) {
                for (ICDFCell c : this.mCells) {
                    ScalarCell scalarCell = (ScalarCell)c;
                    scalarCell.encode(buf);
                }
            }
        }
    }

    @Override
    public ICDFCell[] getCells(ICDFCell[] array) {
        if (!this.mMaterialized) {
            this.materializeCells();
        }
        if (null == array || array.length < this.mCells.length) {
            array = new ICDFCell[this.mCells.length];
        }
        System.arraycopy(this.mCells, 0, array, 0, this.mCells.length);
        return array;
    }

    @Override
    public ICDFCell getCell(int index) {
        if (!this.mMaterialized) {
            this.materializeCells();
        }
        return this.mCells[index];
    }

    @Override
    public int getCellCount() {
        if (!this.mMaterialized) {
            this.materializeCells();
        }
        return this.mCells.length;
    }

    private void materializeCells() {
        if (this.mMaterialized) {
            return;
        }
        if (null == this.mRowBuf || 0 == this.mDataLength) {
            this.mCells = EMPTY_ROW_CELLS;
        } else {
            ArrayList<ScalarCell> cellList = new ArrayList<ScalarCell>(Math.max(1, this.mExpectedCellCount));
            while (this.mRowBuf.hasRemaining()) {
                ScalarCell c = new ScalarCell(this.mRowBuf, this.mDecorationPool, this.mDictReader);
                cellList.add(c);
            }
            this.mCells = cellList.toArray(new ScalarCell[cellList.size()]);
            this.mMaterialized = true;
        }
    }

    @Override
    public String toString() {
        if (this.isEndOfPageTag()) {
            return "[<end-of-page>]";
        }
        if (this.isJumpTag()) {
            return "[<jump:" + this.getRowJump() + " rows, " + this.getByteJump() + " bytes>]";
        }
        return super.toString();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.getRowIndex());
        for (ICDFCell c : this.mCells) {
            hcb.append((Object)c);
        }
        return hcb.toHashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ICDFRow)) {
            return false;
        }
        ICDFRow other = (ICDFRow)o;
        if (this.getRowIndex() != other.getRowIndex()) {
            return false;
        }
        if (this.getCellCount() != other.getCellCount()) {
            return false;
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            if (this.getCell(i).equals(other.getCell(i))) continue;
            return false;
        }
        return true;
    }
}

