/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.decoration.DecorationPool;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.impl.ScalarRow;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class ScalarRowPage {
    private final ByteBuffer mPageBuf;
    private final long mFirstRowIndex;
    private final int mExpectedColumnCount;
    private final DecorationPool mDecorationPool;
    private final ICDFDictionaryReader mDictReader;

    public ScalarRowPage(ByteBuffer pageBuf, int expectedColumnCount, DecorationPool decorationPool, ICDFDictionaryReader dictReader) {
        this.mPageBuf = pageBuf;
        this.mFirstRowIndex = pageBuf.getLong();
        this.mExpectedColumnCount = expectedColumnCount;
        this.mDecorationPool = decorationPool;
        this.mDictReader = dictReader;
    }

    public long getFirstRowIndex() {
        return this.mFirstRowIndex;
    }

    public void copyTo(ByteBuffer dest) {
        dest.put(this.mPageBuf);
    }

    public ICDFRowCursor cursor() {
        return new Cursor();
    }

    public ICDFRow findRow(long rowIndex) throws IOException {
        if (rowIndex < 0L) {
            throw new IllegalArgumentException("rowIndex < 0");
        }
        ICDFRowCursor cur = this.cursor();
        if (cur.position(rowIndex)) {
            return cur.getRow();
        }
        return null;
    }

    private final class Cursor
    implements ICDFRowCursor {
        private final ByteBuffer mRowBuf;
        private ScalarRow mCurrentRow;

        private Cursor() {
            this.mRowBuf = ScalarRowPage.this.mPageBuf.slice().order(ScalarRowPage.this.mPageBuf.order());
            this.mCurrentRow = null;
        }

        @Override
        public long getRowIndex() throws IOException {
            if (null == this.mCurrentRow) {
                return -1L;
            }
            return this.mCurrentRow.getRowIndex();
        }

        @Override
        public ScalarRow getRow() throws IOException {
            return this.mCurrentRow;
        }

        @Override
        public void beforeFirst() throws IOException {
            this.mCurrentRow = null;
            this.mRowBuf.rewind();
        }

        @Override
        public boolean first() throws IOException {
            this.beforeFirst();
            return this.next();
        }

        @Override
        public boolean next() throws IOException {
            ScalarRow r;
            do {
                if (!this.mRowBuf.hasRemaining()) {
                    return false;
                }
                this.mRowBuf.mark();
                r = new ScalarRow(this.mRowBuf, ScalarRowPage.this.mExpectedColumnCount, ScalarRowPage.this.mDecorationPool, ScalarRowPage.this.mDictReader);
                if (r.isEndOfPageTag()) {
                    this.mRowBuf.reset();
                    return false;
                }
                this.mRowBuf.position(this.mRowBuf.position() + r.getEncodedSize());
            } while (r.isJumpTag());
            this.mCurrentRow = r;
            return true;
        }

        @Override
        public boolean position(long rowIndex) throws IOException {
            ScalarRow r;
            if (!(null != this.mCurrentRow && rowIndex >= this.mCurrentRow.getRowIndex() || this.first())) {
                return false;
            }
            if (rowIndex == this.mCurrentRow.getRowIndex()) {
                return true;
            }
            while (true) {
                if (!this.mRowBuf.hasRemaining()) {
                    return false;
                }
                this.mRowBuf.mark();
                r = new ScalarRow(this.mRowBuf, ScalarRowPage.this.mExpectedColumnCount, ScalarRowPage.this.mDecorationPool, ScalarRowPage.this.mDictReader);
                if (r.isEndOfPageTag()) {
                    this.mRowBuf.reset();
                    return false;
                }
                this.mRowBuf.position(this.mRowBuf.position() + r.getEncodedSize());
                if (r.isJumpTag()) {
                    if (ScalarRowPage.this.mFirstRowIndex + (long)r.getRowJump() > rowIndex) continue;
                    this.mRowBuf.position(this.mRowBuf.position() + r.getByteJump());
                    continue;
                }
                if (r.getRowIndex() > rowIndex) {
                    this.mRowBuf.reset();
                    return false;
                }
                if (r.getRowIndex() >= rowIndex) break;
            }
            this.mCurrentRow = r;
            return true;
        }
    }
}

