/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.io.VarIntCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class SheetMetadata {
    private int mColumnCount = 0;
    private int[] mMaxStringLengths = new int[0];
    private long mRowCount = 0L;
    private int mPartitionCount = 0;
    private int mBlockSize = 0;
    private int[] mDataTypes = new int[0];

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public void setColumnCount(int columnCount) {
        if (columnCount < 0) {
            throw new IllegalArgumentException("columnCount < 0");
        }
        this.mColumnCount = columnCount;
    }

    public int[] getMaxStringLengths() {
        return this.mMaxStringLengths;
    }

    public void setMaxStringLengths(int[] maxStringLengths) {
        this.mMaxStringLengths = maxStringLengths;
    }

    public long getRowCount() {
        return this.mRowCount;
    }

    public void setRowCount(long rowCount) {
        if (rowCount < 0L) {
            throw new IllegalArgumentException("rowCount < 0");
        }
        this.mRowCount = rowCount;
    }

    public int getPartitionCount() {
        return this.mPartitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        if (partitionCount < 0) {
            throw new IllegalArgumentException("partitionCount < 0");
        }
        this.mPartitionCount = partitionCount;
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    public void setBlockSize(int blockSize) {
        if (blockSize < 0) {
            throw new IllegalArgumentException("blockSize < 0");
        }
        this.mBlockSize = blockSize;
    }

    public void setDataType(int[] dataTypes) {
        this.mDataTypes = dataTypes;
    }

    public int[] getDataTypes() {
        return this.mDataTypes;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.mMaxStringLengths.length != this.mColumnCount) {
            throw new IllegalStateException("mMaxStringLengths.length != mColumnCount");
        }
        if (this.mDataTypes.length != this.mColumnCount) {
            throw new IllegalStateException("mDataTypes.length != mColumnCount");
        }
        VarIntCoder.writeUnsignedVarInt((int)this.mColumnCount, (OutputStream)out);
        for (int len : this.mMaxStringLengths) {
            VarIntCoder.writeUnsignedVarInt((int)len, (OutputStream)out);
        }
        VarIntCoder.writeUnsignedVarLong((long)this.mRowCount, (OutputStream)out);
        VarIntCoder.writeUnsignedVarInt((int)this.mPartitionCount, (OutputStream)out);
        VarIntCoder.writeUnsignedVarInt((int)this.mBlockSize, (OutputStream)out);
        for (int dType : this.mDataTypes) {
            VarIntCoder.writeUnsignedVarInt((int)dType, (OutputStream)out);
        }
    }

    public void writeTo(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(out);
        }
    }

    public void readFrom(InputStream in) throws IOException {
        int i;
        this.mColumnCount = VarIntCoder.readUnsignedVarInt((InputStream)in);
        this.mMaxStringLengths = new int[this.mColumnCount];
        this.mDataTypes = new int[this.mColumnCount];
        for (i = 0; i < this.mColumnCount; ++i) {
            this.mMaxStringLengths[i] = VarIntCoder.readUnsignedVarInt((InputStream)in);
        }
        this.mRowCount = VarIntCoder.readUnsignedVarLong((InputStream)in);
        this.mPartitionCount = VarIntCoder.readUnsignedVarInt((InputStream)in);
        this.mBlockSize = VarIntCoder.readUnsignedVarInt((InputStream)in);
        for (i = 0; i < this.mColumnCount; ++i) {
            this.mDataTypes[i] = VarIntCoder.readUnsignedVarInt((InputStream)in);
        }
    }

    public void readFrom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.readFrom(in);
        }
    }
}

