/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.decoration.DecorationMap;
import com.ibm.neo.dataimport.cdf.sheet.impl.AbstractCell;
import com.ibm.neo.dataimport.nodel.EDataType;
import java.math.BigDecimal;
import java.util.Date;

public class SimpleCell
extends AbstractCell {
    private final EDataType mDataType;
    private final Object mValue;
    private final DecorationMap mDecorations;

    public SimpleCell(EDataType dataType, Object value, DecorationMap decorations) {
        this.mDataType = dataType;
        this.mValue = value;
        this.mDecorations = decorations;
    }

    @Override
    public EDataType getDataType() {
        return this.mDataType;
    }

    @Override
    public boolean isNull() {
        return this.mValue == null;
    }

    @Override
    public int getNumericScale() {
        if (this.mValue instanceof BigDecimal) {
            return ((BigDecimal)this.mValue).scale();
        }
        return 0;
    }

    @Override
    public boolean booleanValue() {
        if (this.mValue instanceof Boolean) {
            return (Boolean)this.mValue;
        }
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).intValue() != 0;
        }
        return false;
    }

    @Override
    public byte byteValue() {
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).byteValue();
        }
        if (this.mValue instanceof Date) {
            return (byte)(((Date)this.mValue).getTime() & 0xFFL);
        }
        return 0;
    }

    @Override
    public short shortValue() {
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).shortValue();
        }
        if (this.mValue instanceof Date) {
            return (short)(((Date)this.mValue).getTime() & 0xFFFFL);
        }
        return 0;
    }

    @Override
    public char charValue() {
        if (this.mValue instanceof Character) {
            return ((Character)this.mValue).charValue();
        }
        if (this.mValue instanceof Number) {
            return (char)(((Number)this.mValue).longValue() & 0xFFFFL);
        }
        return '\u0000';
    }

    @Override
    public int intValue() {
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).intValue();
        }
        if (this.mValue instanceof Date) {
            return (int)(((Date)this.mValue).getTime() & 0xFFFFFFFFFFFFFFFFL);
        }
        return 0;
    }

    @Override
    public long longValue() {
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).longValue();
        }
        if (this.mValue instanceof Date) {
            return ((Date)this.mValue).getTime();
        }
        return 0L;
    }

    @Override
    public float floatValue() {
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).floatValue();
        }
        if (this.mValue instanceof Date) {
            return ((Date)this.mValue).getTime() & 0xFFFFFFFFFFFFFFFFL;
        }
        return 0.0f;
    }

    @Override
    public double doubleValue() {
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).doubleValue();
        }
        if (this.mValue instanceof Date) {
            return ((Date)this.mValue).getTime();
        }
        return 0.0;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (this.isNull()) {
            return null;
        }
        if (this.mValue instanceof BigDecimal) {
            return (BigDecimal)this.mValue;
        }
        if (this.mValue instanceof Number) {
            return new BigDecimal(this.mValue.toString());
        }
        return BigDecimal.ZERO;
    }

    @Override
    public Date dateValue() {
        if (this.mValue instanceof Date) {
            return (Date)this.mValue;
        }
        if (this.mValue instanceof Number) {
            return new Date(((Number)this.mValue).longValue());
        }
        return null;
    }

    @Override
    public String stringValue() {
        if (this.isNull()) {
            return null;
        }
        if (this.mValue instanceof String) {
            return (String)this.mValue;
        }
        return String.valueOf(this.mValue);
    }

    @Override
    public DecorationMap getDecorations() {
        return this.mDecorations;
    }
}

