/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionary;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFDictionaryWriter;
import com.ibm.neo.util.StringDictionary;
import java.io.IOException;

public class SimpleDictionary
implements ICDFDictionary {
    private final StringDictionary mDictionary = new StringDictionary();

    @Override
    public ICDFDictionaryReader openReader() throws IOException {
        return new Reader();
    }

    @Override
    public ICDFDictionaryWriter openWriter() throws IOException {
        return new Writer();
    }

    @Override
    public void clear() throws IOException {
        this.mDictionary.clear();
    }

    private final class Writer
    implements ICDFDictionaryWriter {
        private boolean mClosed = false;

        private Writer() {
        }

        @Override
        public ICDFDictionary getDictionary() {
            return SimpleDictionary.this;
        }

        @Override
        public long insert(String str) throws IOException {
            return SimpleDictionary.this.mDictionary.reverseLookupOrInsert(str);
        }

        @Override
        public boolean isClosed() {
            return this.mClosed;
        }

        @Override
        public void close() throws IOException {
            this.mClosed = true;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }

    private final class Reader
    implements ICDFDictionaryReader {
        private boolean mClosed = false;

        private Reader() {
        }

        @Override
        public ICDFDictionary getDictionary() {
            return SimpleDictionary.this;
        }

        @Override
        public String lookup(long key) throws IOException {
            return SimpleDictionary.this.mDictionary.lookup((int)key);
        }

        @Override
        public boolean isClosed() {
            return this.mClosed;
        }

        @Override
        public void close() throws IOException {
            this.mClosed = true;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

