/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.impl.AbstractRow;

public class SimpleRow
extends AbstractRow {
    private static final ICDFCell[] EMPTY_CELLS = new ICDFCell[0];
    private final long mRowIndex;
    private final ICDFCell[] mCells;

    public SimpleRow(long rowIndex, ICDFCell[] cells) {
        this.mRowIndex = rowIndex;
        if (null == cells || cells.length == 0) {
            this.mCells = EMPTY_CELLS;
        } else {
            this.mCells = new ICDFCell[cells.length];
            System.arraycopy(cells, 0, this.mCells, 0, cells.length);
        }
    }

    @Override
    public long getRowIndex() {
        return this.mRowIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.mCells.length == 0;
    }

    @Override
    public int getCellCount() {
        return this.mCells.length;
    }

    @Override
    public ICDFCell getCell(int index) {
        return this.mCells[index];
    }

    @Override
    public ICDFCell[] getCells(ICDFCell[] array) {
        if (null == array || array.length < this.mCells.length) {
            array = new ICDFCell[this.mCells.length];
        }
        System.arraycopy(this.mCells, 0, array, 0, this.mCells.length);
        return array;
    }
}

