/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.impl.AbstractRow;
import com.ibm.neo.dataimport.nodel.misc.ColumnRange;
import org.apache.commons.lang.NullArgumentException;

final class SubRow
extends AbstractRow {
    private final long mRowIndex;
    private final ICDFRow mSourceRow;
    private final ColumnRange mRange;

    public SubRow(long rowIndex, ICDFRow sourceRow, ColumnRange range) {
        if (rowIndex < 0L) {
            throw new IllegalArgumentException("rowIndex < 0");
        }
        if (null == sourceRow) {
            throw new NullArgumentException("sourceRow");
        }
        if (null == range) {
            throw new NullArgumentException("range");
        }
        this.mRowIndex = rowIndex;
        this.mSourceRow = sourceRow;
        this.mRange = range.intersect(new ColumnRange(0, sourceRow.getCellCount()));
    }

    @Override
    public long getRowIndex() {
        return this.mRowIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.mRange.isEmpty();
    }

    @Override
    public int getCellCount() {
        return this.mRange.getLength();
    }

    @Override
    public ICDFCell getCell(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.mSourceRow.getCell(index + this.mRange.getStart());
    }

    @Override
    public ICDFCell[] getCells(ICDFCell[] array) {
        if (null == array || array.length < this.getCellCount()) {
            array = new ICDFCell[this.getCellCount()];
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            array[i] = this.getCell(i);
        }
        return array;
    }
}

