/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.SubSheetReader;
import com.ibm.neo.dataimport.cdf.util.CDFUtils;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.dataimport.nodel.misc.CellRange;
import com.ibm.neo.dataimport.nodel.misc.ColumnRange;
import com.ibm.neo.dataimport.nodel.misc.RowRange;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class SubSheet
implements ICDFSheet {
    private final ICDFSheet mSource;
    private final CellRange mRange;
    private int[] mMaxStringLengths;

    public SubSheet(ICDFSheet source, CellRange range) {
        if (null == source) {
            throw new NullArgumentException("source");
        }
        if (null == range) {
            throw new NullArgumentException("range");
        }
        this.mSource = source;
        this.mRange = range.intersect(new CellRange(new RowRange(0L, this.mSource.getRowCount()), new ColumnRange(0, this.mSource.getColumnCount())));
    }

    ICDFSheet getSource() {
        return this.mSource;
    }

    CellRange getRange() {
        return this.mRange;
    }

    @Override
    public SheetInfo getSheetInfo() {
        SheetInfo info = new SheetInfo();
        info.setSheetId(this.getId());
        info.setColumnExtent(this.getColumnCount());
        info.setRowExtent(this.getRowCount());
        return info;
    }

    @Override
    public String getId() {
        return this.mSource.getId();
    }

    @Override
    public File getDataDirectory() {
        return this.mSource.getDataDirectory();
    }

    @Override
    public long getRowCount() {
        return this.mRange.getRowRange().getLength();
    }

    @Override
    public int getColumnCount() {
        return this.mRange.getColumnRange().getLength();
    }

    @Override
    public int getMaxStringLength(int columnIndex) {
        if (this.mMaxStringLengths == null) {
            this.mMaxStringLengths = CDFUtils.computeMaxStringLengths(this);
        }
        return this.mMaxStringLengths[columnIndex];
    }

    @Override
    public EDataType getDataType(int columnIndex) {
        return this.mSource.getDataType(columnIndex);
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public ICDFSheet subSheet(CellRange range) {
        return new SubSheet(this, range);
    }

    @Override
    public ICDFSheetWriter openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICDFSheetReader openReader() throws IOException {
        return new SubSheetReader(this);
    }

    @Override
    public void clear() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadMetadata() throws IOException {
        this.mSource.loadMetadata();
    }

    @Override
    public void saveMetadata() throws IOException {
        this.mSource.saveMetadata();
    }

    @Override
    public void destroy() throws IOException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("source", (Object)this.mSource.getId());
        builder.append("range", (Object)this.mRange);
        builder.append("maxStringLengths", this.mMaxStringLengths);
        return builder.toString();
    }
}

