/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.sheet.impl;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.impl.SubRow;
import com.ibm.neo.dataimport.cdf.sheet.impl.SubSheet;
import com.ibm.neo.dataimport.nodel.misc.CellRange;
import com.ibm.neo.dataimport.nodel.misc.RowRange;
import java.io.IOException;
import org.slf4j.LoggerFactory;

final class SubSheetReader
implements ICDFSheetReader {
    private final SubSheet mSheet;
    private final ICDFSheetReader mSourceReader;
    private boolean mClosed = false;

    public SubSheetReader(SubSheet sheet) throws IOException {
        this.mSheet = sheet;
        this.mSourceReader = this.mSheet.getSource().openReader();
    }

    @Override
    public ICDFSheet getSheet() {
        return this.mSheet;
    }

    @Override
    public ICDFRowCursor cursor() throws IOException {
        return new Cursor();
    }

    @Override
    public ICDFRow rowAt(long rowIndex) throws IOException {
        if (rowIndex < 0L) {
            throw new IllegalArgumentException("rowIndex < 0");
        }
        ICDFRowCursor cur = this.cursor();
        if (cur.position(rowIndex)) {
            return cur.getRow();
        }
        return null;
    }

    private ICDFRow adjustRow(ICDFRow row) {
        CellRange range = this.mSheet.getRange();
        int effectiveWidth = Math.min(Math.max(0, row.getCellCount() - range.getColumnRange().getStart()), range.getColumnRange().getLength());
        ICDFCell[] adjustedCells = new ICDFCell[effectiveWidth];
        for (int i = 0; i < effectiveWidth; ++i) {
            adjustedCells[i] = row.getCell(i + range.getColumnRange().getStart());
        }
        return new SubRow(row.getRowIndex() - range.getRowRange().getStart(), row, this.mSheet.getRange().getColumnRange());
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            this.mSourceReader.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.mClosed) {
                LoggerFactory.getLogger(this.getClass()).warn("Detected a finalized resource that was not properly closed: " + this.toString());
                this.close();
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error("Error caught in finalizer", t);
        }
    }

    private final class Cursor
    implements ICDFRowCursor {
        private final RowRange mRowRange;
        private final ICDFRowCursor mSourceCursor;
        private ICDFRow mCurrentRow = null;
        private boolean mReachedEnd = false;

        public Cursor() throws IOException {
            this.mRowRange = SubSheetReader.this.mSheet.getRange().getRowRange();
            this.mSourceCursor = SubSheetReader.this.mSourceReader.cursor();
            this.beforeFirst();
        }

        @Override
        public long getRowIndex() throws IOException {
            if (null == this.mCurrentRow) {
                return -1L;
            }
            return this.mCurrentRow.getRowIndex();
        }

        @Override
        public ICDFRow getRow() throws IOException {
            return this.mCurrentRow;
        }

        @Override
        public void beforeFirst() throws IOException {
            this.mReachedEnd = false;
            this.mCurrentRow = null;
            if (this.mRowRange.getStart() > 0L) {
                this.mSourceCursor.position(this.mRowRange.getStart() - 1L);
            } else {
                this.mSourceCursor.beforeFirst();
            }
        }

        @Override
        public boolean first() throws IOException {
            this.beforeFirst();
            return this.next();
        }

        @Override
        public boolean next() throws IOException {
            if (this.mReachedEnd) {
                return false;
            }
            if (this.mSourceCursor.next() && this.mSourceCursor.getRowIndex() < this.mRowRange.getEnd()) {
                this.mCurrentRow = SubSheetReader.this.adjustRow(this.mSourceCursor.getRow());
                return true;
            }
            this.mReachedEnd = true;
            return false;
        }

        @Override
        public boolean position(long rowIndex) throws IOException {
            if (rowIndex < this.mRowRange.getEnd() && this.mSourceCursor.position(rowIndex + this.mRowRange.getStart())) {
                this.mReachedEnd = false;
                this.mCurrentRow = SubSheetReader.this.adjustRow(this.mSourceCursor.getRow());
                return true;
            }
            return false;
        }
    }
}

